/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ClickableFormPanel;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ContainerEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.util.Util;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Container;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormPanelWithSavePoint
extends ClickableFormPanel {
    private List<Listener<DirtyChangeEvent>> dirtyChangeListeners = new ArrayList<Listener<DirtyChangeEvent>>();
    private Set<Field<?>> dirtyCheckIgnoredFields = new HashSet();
    private Map<String, Object> dirtyCheckSavePointValues = new HashMap<String, Object>();

    public FormPanelWithSavePoint() {
        this.addListener(Events.Add, (Listener)new Listener<ContainerEvent>(){

            public void handleEvent(ContainerEvent ce) {
                ArrayList fields = new ArrayList();
                FormPanelWithSavePoint.this.getDirtyCheckFields(ce.getItem(), fields);
                for (Field field : fields) {
                    field.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

                        public void handleEvent(FieldEvent fe) {
                            DirtyChangeEvent dirtyChangedEvent = new DirtyChangeEvent(FormPanelWithSavePoint.this);
                            for (Listener dirtyChangeListener : FormPanelWithSavePoint.this.dirtyChangeListeners) {
                                dirtyChangeListener.handleEvent((BaseEvent)dirtyChangedEvent);
                            }
                        }
                    });
                }
            }
        });
    }

    public void setSavePoint() {
        this.dirtyCheckSavePointValues.clear();
        for (Field<?> field : this.getDirtyCheckFields()) {
            this.setSavePointValue(field);
        }
    }

    public void reset() {
        super.reset();
        this.setSavePoint();
    }

    public void resetToSavePoint() {
        for (Field<?> field : this.getDirtyCheckFields()) {
            field.setValue(this.getSavePointValue(field));
        }
    }

    private void setSavePointValue(Field<?> field) {
        this.dirtyCheckSavePointValues.put(field.getId(), field.getValue());
    }

    private Object getSavePointValue(Field<?> field) {
        if (this.dirtyCheckSavePointValues.containsKey(field.getId())) {
            return this.dirtyCheckSavePointValues.get(field.getId());
        }
        return field.getOriginalValue();
    }

    private List<Field<?>> getDirtyCheckFields() {
        ArrayList fields = new ArrayList();
        this.getDirtyCheckFields((Component)this, fields);
        return fields;
    }

    private void getDirtyCheckFields(Component component, List<Field<?>> fields) {
        block3: {
            block4: {
                block2: {
                    if (!(component instanceof MultiField)) break block2;
                    MultiField multifield = (MultiField)component;
                    for (Component item : multifield.getAll()) {
                        this.getDirtyCheckFields(item, fields);
                    }
                    break block3;
                }
                if (!(component instanceof Field)) break block4;
                fields.add((Field)component);
                break block3;
            }
            if (!(component instanceof Container)) break block3;
            Container container = (Container)component;
            for (Component item : container.getItems()) {
                this.getDirtyCheckFields(item, fields);
            }
        }
    }

    public void addDirtyCheckIgnoredField(Field<?> field) {
        this.dirtyCheckIgnoredFields.add(field);
    }

    public boolean isDirtyForSavePoint() {
        for (Field<?> field : this.getDirtyCheckFields()) {
            if (this.dirtyCheckIgnoredFields.contains(field) || !field.isVisible()) continue;
            Object currentValue = field.getValue();
            Object savePointValue = this.getSavePointValue(field);
            if (currentValue instanceof String && Util.isEmptyString((String)((String)currentValue))) {
                currentValue = null;
            }
            if (savePointValue instanceof String && Util.isEmptyString((String)((String)savePointValue))) {
                savePointValue = null;
            }
            if (Util.equalWithNull((Object)currentValue, (Object)savePointValue)) continue;
            return true;
        }
        return false;
    }

    public void addDirtyChangeListener(Listener<DirtyChangeEvent> listener) {
        this.dirtyChangeListeners.add(listener);
    }

    public class DirtyChangeEvent
    extends BaseEvent {
        private boolean isDirtyForSavePoint;

        public DirtyChangeEvent(FormPanelWithSavePoint form) {
            super((Object)form);
            this.isDirtyForSavePoint = form.isDirtyForSavePoint();
        }

        public boolean isDirtyForSavePoint() {
            return this.isDirtyForSavePoint;
        }
    }
}

