/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.EntityVisitModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.DateRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityVisitComparatorByTimeStamp;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityVisit;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treegrid.WidgetTreeGridCellRenderer;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class HistoryWidget
extends ContentPanel {
    public HistoryWidget(final IViewContext<?> viewContext) {
        this.setLayout((Layout)new FitLayout());
        this.setHeaderVisible(true);
        this.setHeading(viewContext.getMessage("last_visits", new Object[0]));
        final TreeStore<ModelData> store = this.createStore(viewContext);
        Button clearButton = new Button(viewContext.getMessage("clear", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                List<EntityVisit> visits = viewContext.getDisplaySettingsManager().getVisits();
                visits.clear();
                store.removeAll();
            }
        });
        this.getHeader().addTool((Component)clearButton);
        ColumnModel columnModel = this.createColumnModel(viewContext);
        TreeGrid treeGrid = new TreeGrid(store, columnModel);
        treeGrid.setAutoExpandColumn("code");
        treeGrid.getTreeView().setForceFit(true);
        treeGrid.getTreeView().setSortingEnabled(false);
        treeGrid.getStyle().setNodeCloseIcon(null);
        treeGrid.getStyle().setNodeOpenIcon(null);
        treeGrid.setAutoExpand(true);
        treeGrid.setHideHeaders(true);
        this.add((Component)treeGrid);
    }

    private TreeStore<ModelData> createStore(IViewContext<?> viewContext) {
        EntityKind[] values;
        TreeStore store = new TreeStore();
        List<EntityVisit> visits = viewContext.getDisplaySettingsManager().getVisits();
        Collections.sort(visits, new EntityVisitComparatorByTimeStamp());
        EntityKind[] entityKindArray = values = EntityKind.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind entityKind = entityKindArray[n2];
            String entityKindAsString = entityKind.toString();
            HashMap<String, ArrayList<EntityVisit>> typeToVisitMap = new HashMap<String, ArrayList<EntityVisit>>();
            for (EntityVisit visit : visits) {
                if (!entityKindAsString.equals(visit.getEntityKind())) continue;
                ArrayList<EntityVisit> list = (ArrayList<EntityVisit>)typeToVisitMap.get(visit.getEntityTypeCode());
                if (list == null) {
                    list = new ArrayList<EntityVisit>();
                    typeToVisitMap.put(visit.getEntityTypeCode(), list);
                }
                list.add(visit);
            }
            if (!typeToVisitMap.isEmpty()) {
                SimpleModel item = new SimpleModel(String.valueOf(entityKind.getDescription()) + "s");
                store.add((ModelData)item, true);
                Object[] types = typeToVisitMap.keySet().toArray(new String[0]);
                Arrays.sort(types);
                Object[] objectArray = types;
                int n3 = types.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object type = objectArray[n4];
                    SimpleModel typeModel = new SimpleModel((String)type);
                    store.add((ModelData)item, (ModelData)typeModel, true);
                    List list = (List)typeToVisitMap.get(type);
                    HashSet<String> permIds = new HashSet<String>();
                    for (EntityVisit visit : list) {
                        String permID = visit.getPermID();
                        if (permIds.contains(permID)) continue;
                        permIds.add(permID);
                        store.add((ModelData)typeModel, (ModelData)new EntityVisitModel(visit), false);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return store;
    }

    private ColumnModel createColumnModel(final IViewContext<?> viewContext) {
        ColumnConfig columnConfig = new ColumnConfig("code", "", 1);
        columnConfig.setRenderer((GridCellRenderer)new WidgetTreeGridCellRenderer<ModelData>(){

            public Widget getWidget(ModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<ModelData> store, Grid<ModelData> grid) {
                if (model instanceof EntityVisitModel) {
                    String href;
                    String permID;
                    EntityVisitModel evm = (EntityVisitModel)model;
                    EntityVisit visit = evm.getVisit();
                    String displayText = visit.getIdentifier();
                    final EntityKind entityKind = EntityKind.valueOf(visit.getEntityKind());
                    if (entityKind == EntityKind.MATERIAL) {
                        permID = StringEscapeUtils.unescapeHtml(visit.getPermID());
                        href = LinkExtractor.tryExtract(MaterialIdentifier.tryParseIdentifier(permID));
                    } else {
                        permID = visit.getPermID();
                        href = LinkExtractor.createPermlink(entityKind, permID);
                    }
                    ClickHandler listener = new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            OpenEntityDetailsTabHelper.open(viewContext, entityKind, permID, WidgetUtils.ifSpecialKeyPressed(event.getNativeEvent()));
                        }
                    };
                    Widget link = LinkRenderer.getLinkWidget(displayText, listener, href);
                    String date = DateRenderer.renderDate(new Date(visit.getTimeStamp()), "yyyy-MM-dd HH:mm");
                    FlowPanel panel = new FlowPanel();
                    panel.add(link);
                    panel.add((Widget)new InlineHTML(" (" + date + ")"));
                    return panel;
                }
                return new Label(model.get(property).toString());
            }
        });
        columnConfig.setMenuDisabled(true);
        return new ColumnModel(Arrays.asList(columnConfig));
    }

    private static final class SimpleModel
    extends SimplifiedBaseModel {
        private static final long serialVersionUID = 1L;

        public SimpleModel(String item) {
            this.set("code", item);
        }
    }
}

