/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IInfoHandler;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.InfoType;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.PopupDialogBasedInfoHandler;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.widget.Html;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public final class InfoBox
extends Composite
implements IInfoHandler {
    private static final int TRUNCATE_THRESHOLD = 200;
    private static final String TRUNCATE_SUFFIX = "...";
    private static final String PLACEHOLDER_TEXT = "X";
    private static final String WHITE = "#ffffff";
    private Panel mainPanel;
    private String fullMessage;
    private InfoType messageType;
    private Html truncatedMessageHtml = new Html();
    private PopupDialogBasedInfoHandler fullMessageDialog;
    private Anchor showFullMessageLink;
    private Timer progressTimer;

    public InfoBox(IMessageProvider messageProvider) {
        this(messageProvider, HasHorizontalAlignment.ALIGN_DEFAULT);
    }

    public InfoBox(final IMessageProvider messageProvider, HasHorizontalAlignment.HorizontalAlignmentConstant alignment) {
        this.showFullMessageLink = new Anchor(messageProvider.getMessage("info_box_show_full_message", new Object[0]));
        this.showFullMessageLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (InfoBox.this.fullMessageDialog != null) {
                    InfoBox.this.fullMessageDialog.hide();
                }
                InfoBox.this.fullMessageDialog = new PopupDialogBasedInfoHandler(messageProvider);
                InfoBox.this.fullMessageDialog.display(InfoBox.this.messageType, InfoBox.this.fullMessage);
            }
        });
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.setHorizontalAlignment(alignment);
        verticalPanel.add((Widget)this.truncatedMessageHtml);
        verticalPanel.add((Widget)this.showFullMessageLink);
        this.mainPanel = new SimplePanel();
        Style mainPanelStyle = this.mainPanel.getElement().getStyle();
        mainPanelStyle.setBorderStyle(Style.BorderStyle.SOLID);
        mainPanelStyle.setBorderWidth(1.0, Style.Unit.PX);
        mainPanelStyle.setPadding(3.0, Style.Unit.PX);
        this.mainPanel.add((Widget)verticalPanel);
        this.initWidget((Widget)this.mainPanel);
        this.reset();
    }

    @Override
    public final void displayError(String text) {
        this.display(text, InfoType.ERROR);
    }

    @Override
    public final void displayInfo(String text) {
        this.display(text, InfoType.INFO);
    }

    @Override
    public final void displayProgress(final String text) {
        this.display(text, InfoType.PROGRESS);
        this.progressTimer = new Timer(){
            String dots;

            public void run() {
                this.dots = this.dots != null && this.dots.length() < 6 ? String.valueOf(this.dots) + "." : InfoBox.TRUNCATE_SUFFIX;
                InfoBox.this.truncatedMessageHtml.setHtml(String.valueOf(InfoBox.this.truncate(text)) + this.dots);
            }
        };
        this.progressTimer.run();
        this.progressTimer.scheduleRepeating(500);
    }

    public final void display(String text, InfoType type) {
        if (this.progressTimer != null) {
            this.progressTimer.cancel();
            this.progressTimer = null;
        }
        if (!StringUtils.isBlank(text)) {
            Style mainPanelStyle = this.mainPanel.getElement().getStyle();
            mainPanelStyle.setColor("#000000");
            mainPanelStyle.setBackgroundColor(type.getBackgroundColor());
            mainPanelStyle.setBorderColor(type.getBorderColor());
            this.fullMessage = text;
            this.messageType = type;
            if (this.shouldTruncate(text)) {
                this.truncatedMessageHtml.setHtml(this.truncate(text));
                this.showFullMessageLink.setVisible(true);
            } else {
                this.truncatedMessageHtml.setHtml(text);
                this.showFullMessageLink.setVisible(false);
            }
            if (this.fullMessageDialog != null) {
                this.fullMessageDialog.hide();
                this.fullMessageDialog = null;
            }
            this.getElement().scrollIntoView();
        }
    }

    public final void reset() {
        if (this.progressTimer != null) {
            this.progressTimer.cancel();
            this.progressTimer = null;
        }
        Style mainPanelStyle = this.mainPanel.getElement().getStyle();
        mainPanelStyle.setBackgroundColor(WHITE);
        mainPanelStyle.setBorderColor(WHITE);
        mainPanelStyle.setColor(WHITE);
        this.fullMessage = null;
        this.truncatedMessageHtml.setHtml(PLACEHOLDER_TEXT);
        this.showFullMessageLink.setVisible(false);
        if (this.fullMessageDialog != null) {
            this.fullMessageDialog.hide();
            this.fullMessageDialog = null;
        }
    }

    private boolean shouldTruncate(String text) {
        return text != null && text.length() > 200;
    }

    private String truncate(String text) {
        if (this.shouldTruncate(text)) {
            return String.valueOf(text.substring(0, 200)) + TRUNCATE_SUFFIX;
        }
        return text;
    }
}

