/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardDataModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardState;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.wizard.IWizardStateChangeListener;
import com.google.gwt.core.client.JavaScriptException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class WizardWorkflowModel {
    private static final List<IWizardState> EMPTY_LIST = Arrays.asList(new IWizardState[0]);
    private final List<IWizardStateChangeListener> changeListeners = new ArrayList<IWizardStateChangeListener>();
    private final Map<IWizardState, List<IWizardState>> transitionsToNext = new HashMap<IWizardState, List<IWizardState>>();
    private final Map<IWizardState, List<IWizardState>> transitionsToPrevious = new HashMap<IWizardState, List<IWizardState>>();
    private final Stack<IWizardState> visitedStates = new Stack();
    private final IWizardDataModel dataModel;
    private IWizardState initialState;

    public WizardWorkflowModel(IWizardDataModel dataModel) {
        this.dataModel = dataModel;
    }

    void addStateChangeListener(IWizardStateChangeListener stateChangeListener) {
        this.changeListeners.add(stateChangeListener);
    }

    public void addTransition(IWizardState state, IWizardState nextState) {
        List<IWizardState> nextStates = this.transitionsToNext.get(state);
        if (nextStates == null) {
            nextStates = new ArrayList<IWizardState>();
            this.transitionsToNext.put(state, nextStates);
        }
        nextStates.add(nextState);
        List<IWizardState> previousStates = this.transitionsToPrevious.get(nextState);
        if (previousStates == null) {
            previousStates = new ArrayList<IWizardState>();
            this.transitionsToPrevious.put(nextState, previousStates);
        }
        previousStates.add(state);
        if (this.initialState == null) {
            this.initialState = state;
        }
    }

    void nextState() {
        List<IWizardState> nextStates = this.getNextStates();
        if (nextStates.size() == 1) {
            this.setNextState(nextStates.get(0));
        } else if (nextStates.size() > 1) {
            IWizardState nextState = this.dataModel.determineNextState(this.tryGetCurrentState());
            if (!nextStates.contains(nextState)) {
                throw new JavaScriptException("Error", "Next state " + nextState + " is not from " + nextStates);
            }
            this.setNextState(nextState);
        } else {
            this.fireStateChangeEvent(this.tryGetCurrentState(), null);
        }
    }

    private void setNextState(IWizardState nextState) {
        IWizardState oldState = this.tryGetCurrentState();
        this.visitedStates.push(nextState);
        this.fireStateChangeEvent(oldState, nextState);
    }

    private void fireStateChangeEvent(IWizardState oldState, IWizardState nextState) {
        for (IWizardStateChangeListener listener : this.changeListeners) {
            listener.stateChanged(oldState, nextState);
        }
    }

    boolean hasNextState(IWizardState state) {
        return this.transitionsToNext.get(state) != null;
    }

    private List<IWizardState> getNextStates() {
        IWizardState currentState = this.tryGetCurrentState();
        if (currentState == null) {
            return this.initialState == null ? EMPTY_LIST : Arrays.asList(this.initialState);
        }
        List<IWizardState> nextStates = this.transitionsToNext.get(currentState);
        return nextStates == null ? EMPTY_LIST : nextStates;
    }

    void previousState() {
        if (!this.visitedStates.isEmpty()) {
            IWizardState oldState = this.visitedStates.pop();
            this.fireStateChangeEvent(oldState, this.tryGetCurrentState());
        }
    }

    boolean hasPreviousState(IWizardState state) {
        return this.transitionsToPrevious.get(state) != null;
    }

    IWizardState tryGetCurrentState() {
        return this.visitedStates.isEmpty() ? null : this.visitedStates.peek();
    }
}

