/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GenericViewModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;

public class DataSetUtils {
    private static final String MAIN_DATA_SET_PATH = "mdsPath";
    private static final String MAIN_DATA_SET_PATTERN = "mdsPattern";
    private static final String AUTO_RESOLVE = "autoResolve";
    private static final String MODE = "mode";

    public static String createDataViewUrl(AbstractExternalData dataSet, GenericViewModel model, String modeOrNull, boolean autoResolve) {
        URLMethodWithParameters methodWithParameters = new URLMethodWithParameters(String.valueOf(dataSet.getDataStore().getDownloadUrl()) + "/" + dataSet.getCode());
        String sessionID = model.getSessionContext().getSessionID();
        methodWithParameters.addParameter("sessionID", sessionID);
        if (modeOrNull != null) {
            methodWithParameters.addParameter(MODE, modeOrNull);
        }
        if (autoResolve) {
            methodWithParameters.addParameter(AUTO_RESOLVE, autoResolve);
            String mainDataSetPattern = dataSet.getDataSetType().getMainDataSetPattern();
            if (!StringUtils.isBlank(mainDataSetPattern)) {
                methodWithParameters.addParameter(MAIN_DATA_SET_PATTERN, mainDataSetPattern);
            }
            if (!StringUtils.isBlank(dataSet.getDataSetType().getMainDataSetPath())) {
                methodWithParameters.addParameter(MAIN_DATA_SET_PATH, dataSet.getDataSetType().getMainDataSetPath());
            }
        }
        String url = methodWithParameters.toString();
        return url;
    }
}

