/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util;

import com.google.gwt.http.client.URL;
import java.util.ArrayList;

public class URLListEncoder {
    private static final char ITEM_LIST_SEPARATOR = ',';
    private static final char ITEM_LIST_SEPARATOR_NEXT_CHAR = ' ';
    private static final String ESCAPED_SEPARATOR = ",,";

    public static String encodeItemList(String[] items) {
        return URLListEncoder.encodeItemList(items, true);
    }

    public static String encodeItemList(String[] items, boolean urlEncoding) {
        StringBuffer sb = new StringBuffer();
        String escapedItemListSeparator = ESCAPED_SEPARATOR;
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            assert (item.length() > 0) : "cannot encode an empty item";
            item = item.replaceAll(",", escapedItemListSeparator);
            if (sb.length() > 0) {
                sb.append(',');
                sb.append(' ');
            }
            sb.append(item);
            ++n2;
        }
        String text = sb.toString();
        return urlEncoding ? URLListEncoder.encode(text) : text;
    }

    public static String[] decodeItemList(String itemsList) {
        return URLListEncoder.decodeItemList(itemsList, true);
    }

    public static String[] decodeItemList(String itemsList, boolean urlDecoding) {
        int startIx;
        ArrayList<String> list = new ArrayList<String>();
        String decoded = urlDecoding ? URLListEncoder.decode(itemsList) : itemsList;
        int length = decoded.length();
        int endIx = startIx = 0;
        while (startIx < length) {
            if ((endIx = decoded.indexOf(44, endIx)) != -1 && endIx < length - 1 && decoded.charAt(endIx + 1) == ',') {
                endIx += 2;
                continue;
            }
            if (endIx == -1) {
                endIx = length;
            }
            String item = decoded.substring(startIx, endIx);
            item = item.replaceAll(ESCAPED_SEPARATOR, ",");
            list.add(item);
            endIx = startIx = endIx + 2;
        }
        return list.toArray(new String[list.size()]);
    }

    private static String encode(String text) {
        return URL.encodeQueryString((String)text);
    }

    private static String decode(String text) {
        return URL.decodeQueryString((String)text);
    }
}

