/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log.IProfilingTable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ProfilingTable
implements IProfilingTable {
    private final ArrayList<ProfilingEventStarted> startEvents = new ArrayList();
    private final HashMap<Integer, Date> stopEvents = new HashMap();

    public static IProfilingTable create(boolean isLoggingEnabled) {
        if (isLoggingEnabled) {
            return new ProfilingTable();
        }
        return ProfilingTable.createProfilingDummy();
    }

    private static IProfilingTable createProfilingDummy() {
        return new IProfilingTable(){

            @Override
            public void clearLog() {
            }

            @Override
            public List<String> getLoggedEvents() {
                return new ArrayList<String>();
            }

            @Override
            public boolean isLoggingEnabled() {
                return false;
            }

            @Override
            public int log(String description) {
                return 0;
            }

            @Override
            public void log(int taskId, String description) {
            }

            @Override
            public void logStop(int taskId) {
            }
        };
    }

    private ProfilingTable() {
    }

    @Override
    public boolean isLoggingEnabled() {
        return true;
    }

    @Override
    public int log(String description) {
        int taskId = this.startEvents.size();
        this.startEvents.add(new ProfilingEventStarted(taskId, description));
        return taskId;
    }

    @Override
    public void log(int taskId, String description) {
        this.startEvents.add(new ProfilingEventStarted(taskId, description));
    }

    @Override
    public void logStop(int taskId) {
        this.stopEvents.put(taskId, new Date());
    }

    @Override
    public void clearLog() {
        this.startEvents.clear();
        this.stopEvents.clear();
    }

    @Override
    public List<String> getLoggedEvents() {
        ArrayList<String> result = new ArrayList<String>();
        for (ProfilingEventStarted event : this.startEvents) {
            Date stopDateOrNull = this.stopEvents.get(event.getTaskId());
            result.add(this.createEventDescription(event, stopDateOrNull));
        }
        return result;
    }

    private String createEventDescription(ProfilingEventStarted event, Date stopDateOrNull) {
        String eventDesc = DurationPrinter.printTime(event.getTimestamp());
        if (stopDateOrNull != null) {
            long durationInMilisec = stopDateOrNull.getTime() - event.getTimestamp().getTime();
            String durationText = DurationPrinter.printDuration(durationInMilisec);
            eventDesc = String.valueOf(eventDesc) + " [" + DurationPrinter.printTime(stopDateOrNull) + ": " + durationText + "]";
        }
        return String.valueOf(eventDesc) + " " + event.getDescription();
    }

    private static class DurationPrinter {
        private DurationPrinter() {
        }

        public static String printTime(Date date) {
            long durationInMilisec = date.getTime();
            long milisec = DurationPrinter.getMilisecPart(durationInMilisec);
            long sec = DurationPrinter.getSecondsPart(durationInMilisec);
            long min = DurationPrinter.getMinutesPart(durationInMilisec);
            long hour = DurationPrinter.getHoursPart(durationInMilisec);
            return String.valueOf(DurationPrinter.asTwoDigits(hour)) + ":" + DurationPrinter.asTwoDigits(min) + ":" + DurationPrinter.asTwoDigits(sec) + "." + DurationPrinter.asThreeDigits(milisec);
        }

        private static String asTwoDigits(long value) {
            if (value < 10L) {
                return "0" + value;
            }
            return "" + value;
        }

        private static String asThreeDigits(long value) {
            if (value < 10L) {
                return "00" + value;
            }
            if (value < 100L) {
                return "0" + value;
            }
            return "" + value;
        }

        public static String printDuration(long durationInMilisec) {
            long milisec = DurationPrinter.getMilisecPart(durationInMilisec);
            long sec = DurationPrinter.getSecondsPart(durationInMilisec);
            long min = DurationPrinter.getMinutesAll(durationInMilisec);
            String result = "";
            if (min > 0L) {
                result = String.valueOf(result) + DurationPrinter.asTwoDigits(min) + "min ";
            }
            if (sec > 0L) {
                result = String.valueOf(result) + DurationPrinter.asTwoDigits(sec) + "sec ";
            }
            result = String.valueOf(result) + DurationPrinter.asThreeDigits(milisec) + "msec";
            return result;
        }

        private static long getMilisecPart(long durationInMilisec) {
            return durationInMilisec % 1000L;
        }

        private static long getSecondsPart(long durationInMilisec) {
            return durationInMilisec / 1000L % 60L;
        }

        private static long getMinutesPart(long durationInMilisec) {
            return durationInMilisec / 60000L % 60L;
        }

        private static long getHoursPart(long durationInMilisec) {
            return (durationInMilisec / 3600000L + 2L) % 24L;
        }

        private static long getMinutesAll(long durationInMilisec) {
            return durationInMilisec / 60000L;
        }
    }

    private static class ProfilingEventStarted {
        private final Date timestamp = new Date();
        private final int taskId;
        private final String description;

        public ProfilingEventStarted(int taskId, String description) {
            this.taskId = taskId;
            this.description = description;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public int getTaskId() {
            return this.taskId;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

