/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.dto;

import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridFilters;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetFetchConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SortInfo;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultResultSetConfig<K, T>
implements IResultSetConfig<K, T>,
IsSerializable {
    private int limit = -1;
    private int offset = 0;
    private SortInfo sortInfo = new SortInfo();
    private ResultSetFetchConfig<K> cacheConfig = ResultSetFetchConfig.createComputeAndCache();
    private Set<IColumnDefinition<T>> availableColumns;
    private Set<String> idsOfPresentedColumns;
    private GridFilters<T> filters = GridFilters.createEmptyFilter();
    private String gridDisplayIdOrNull;
    private int errorMessageFormatFlags = 0;
    private int ERROR_MESSAGE_FLAG_JYTHON_LONG = 0;

    public static <K, T> DefaultResultSetConfig<K, T> createFetchAll() {
        return new DefaultResultSetConfig<K, T>();
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public final void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public final void setCacheConfig(ResultSetFetchConfig<K> cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    @Override
    public GridFilters<T> getFilters() {
        return this.filters;
    }

    public final void setAvailableColumns(Set<IColumnDefinition<T>> availableColumns) {
        this.availableColumns = availableColumns;
    }

    @Override
    public Set<String> getIDsOfPresentedColumns() {
        return this.idsOfPresentedColumns;
    }

    public void setPresentedColumns(List<IColumnDefinition<T>> presentedColumns) {
        HashSet<String> ids = new HashSet<String>();
        for (IColumnDefinition<T> columnDefinition : presentedColumns) {
            ids.add(columnDefinition.getIdentifier());
        }
        this.setIDsOfPresentedColumns(ids);
    }

    public void setIDsOfPresentedColumns(Set<String> idsOfPresentedColumns) {
        this.idsOfPresentedColumns = idsOfPresentedColumns;
    }

    public final void copyPagingConfig(DefaultResultSetConfig<K, T> resultSetConfig) {
        this.setLimit(resultSetConfig.getLimit());
        this.setOffset(resultSetConfig.getOffset());
        this.setAvailableColumns(resultSetConfig.getAvailableColumns());
        this.setIDsOfPresentedColumns(resultSetConfig.getIDsOfPresentedColumns());
        this.setSortInfo(resultSetConfig.getSortInfo());
        this.setFilters(resultSetConfig.getFilters());
        this.setCacheConfig(resultSetConfig.getCacheConfig());
        this.setGridDisplayId(resultSetConfig.tryGetGridDisplayId());
        this.setCustomColumnErrorMessageLong(resultSetConfig.isCustomColumnErrorMessageLong());
    }

    @Override
    public final int getLimit() {
        return this.limit;
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    @Override
    public final Set<IColumnDefinition<T>> getAvailableColumns() {
        return this.availableColumns;
    }

    @Override
    public final SortInfo getSortInfo() {
        return this.sortInfo;
    }

    @Override
    public final ResultSetFetchConfig<K> getCacheConfig() {
        return this.cacheConfig;
    }

    public void setFilters(GridFilters<T> filters) {
        this.filters = filters;
    }

    public void setGridDisplayId(String gridDisplayIdOrNull) {
        this.gridDisplayIdOrNull = gridDisplayIdOrNull;
    }

    @Override
    public String tryGetGridDisplayId() {
        return this.gridDisplayIdOrNull;
    }

    @Override
    public boolean isCustomColumnErrorMessageLong() {
        return (this.errorMessageFormatFlags & 1 << this.ERROR_MESSAGE_FLAG_JYTHON_LONG) > 0;
    }

    public void setCustomColumnErrorMessageLong(boolean longMessages) {
        if (longMessages != this.isCustomColumnErrorMessageLong()) {
            this.errorMessageFormatFlags ^= 1 << this.ERROR_MESSAGE_FLAG_JYTHON_LONG;
        }
    }
}

