/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.dto;

import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListEntityDisplayCriteriaKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import com.google.gwt.user.client.rpc.IsSerializable;

public class ListSampleDisplayCriteria
extends DefaultResultSetConfig<String, Sample>
implements IsSerializable {
    private ListEntityDisplayCriteriaKind criteriaKind;
    private SampleType allSampleTypeOrNull;
    private DetailedSearchCriteria searchCriteriaOrNull;
    private ListSampleCriteria listCriteriaOrNull;
    private MetaprojectCriteria metaprojectCriteriaOrNull;

    public static ListSampleDisplayCriteria createForContainer(TechId containerSampleId) {
        return new ListSampleDisplayCriteria(ListSampleCriteria.createForContainer(containerSampleId));
    }

    public static ListSampleDisplayCriteria createForParent(TechId parentSampleId) {
        return new ListSampleDisplayCriteria(ListSampleCriteria.createForParent(parentSampleId));
    }

    public static ListSampleDisplayCriteria createForChild(TechId childSampleId) {
        return new ListSampleDisplayCriteria(ListSampleCriteria.createForChild(childSampleId));
    }

    public static ListSampleDisplayCriteria createForExperiment(TechId experimentId) {
        return new ListSampleDisplayCriteria(ListSampleCriteria.createForExperiment(experimentId));
    }

    public static ListSampleDisplayCriteria createForMetaproject(MetaprojectCriteria criteria) {
        return new ListSampleDisplayCriteria(criteria);
    }

    public static ListSampleDisplayCriteria createForSearch() {
        return ListSampleDisplayCriteria.createForSearch(new DetailedSearchCriteria());
    }

    private static ListSampleDisplayCriteria createForSearch(DetailedSearchCriteria searchCriteria) {
        return new ListSampleDisplayCriteria(searchCriteria);
    }

    private ListSampleDisplayCriteria(DetailedSearchCriteria searchCriteria) {
        assert (searchCriteria != null) : "search criteria not set";
        this.criteriaKind = ListEntityDisplayCriteriaKind.SEARCH;
        this.setSearchCriteriaOrNull(searchCriteria);
    }

    public ListSampleDisplayCriteria(ListSampleCriteria listCriteria) {
        assert (listCriteria != null) : "list criteria not set";
        this.criteriaKind = ListEntityDisplayCriteriaKind.BROWSE;
        this.setListCriteriaOrNull(listCriteria);
    }

    public ListSampleDisplayCriteria(MetaprojectCriteria metaprojectCriteria) {
        assert (metaprojectCriteria != null) : "metaproject criteria not set";
        this.criteriaKind = ListEntityDisplayCriteriaKind.METAPROJECT;
        this.setMetaprojectCriteriaOrNull(metaprojectCriteria);
    }

    public ListEntityDisplayCriteriaKind getCriteriaKind() {
        return this.criteriaKind;
    }

    public ListSampleCriteria getBrowseCriteria() {
        assert (this.getCriteriaKind() == ListEntityDisplayCriteriaKind.BROWSE) : "not a browse criteria";
        return this.getListCriteriaOrNull();
    }

    public DetailedSearchCriteria getSearchCriteria() {
        assert (this.getCriteriaKind() == ListEntityDisplayCriteriaKind.SEARCH) : "not a search criteria";
        return this.getSearchCriteriaOrNull();
    }

    public MetaprojectCriteria getMetaprojectCriteria() {
        assert (this.getCriteriaKind() == ListEntityDisplayCriteriaKind.METAPROJECT) : "not a metaproject criteria";
        return this.getMetaprojectCriteriaOrNull();
    }

    public void updateSearchCriteria(DetailedSearchCriteria newSearchCriteria) {
        assert (this.getCriteriaKind() == ListEntityDisplayCriteriaKind.SEARCH) : "not a search criteria";
        assert (newSearchCriteria != null) : "new search criteria not set";
        this.setSearchCriteriaOrNull(newSearchCriteria);
    }

    private ListSampleCriteria getListCriteriaOrNull() {
        return this.listCriteriaOrNull;
    }

    private void setListCriteriaOrNull(ListSampleCriteria listCriteriaOrNull) {
        this.listCriteriaOrNull = listCriteriaOrNull;
    }

    private DetailedSearchCriteria getSearchCriteriaOrNull() {
        return this.searchCriteriaOrNull;
    }

    private void setSearchCriteriaOrNull(DetailedSearchCriteria searchCriteriaOrNull) {
        this.searchCriteriaOrNull = searchCriteriaOrNull;
    }

    public MetaprojectCriteria getMetaprojectCriteriaOrNull() {
        return this.metaprojectCriteriaOrNull;
    }

    public void setMetaprojectCriteriaOrNull(MetaprojectCriteria metaprojectCriteriaOrNull) {
        this.metaprojectCriteriaOrNull = metaprojectCriteriaOrNull;
    }

    public void setAllSampleType(SampleType sampleType) {
        this.allSampleTypeOrNull = sampleType;
    }

    public SampleType tryGetSampleType() {
        if (this.allSampleTypeOrNull != null) {
            return this.allSampleTypeOrNull;
        }
        return this.listCriteriaOrNull != null ? this.listCriteriaOrNull.getSampleType() : null;
    }

    private ListSampleDisplayCriteria() {
    }
}

