/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.dto;

import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListEntityDisplayCriteriaKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.google.gwt.user.client.rpc.IsSerializable;

public class ListSampleDisplayCriteria2
extends DefaultResultSetConfig<String, TableModelRowWithObject<Sample>>
implements IsSerializable {
    private ListEntityDisplayCriteriaKind criteriaKind;
    private SampleType allSampleTypeOrNull;
    private DetailedSearchCriteria searchCriteriaOrNull;
    private ListSampleCriteria listCriteriaOrNull;
    private MetaprojectCriteria metaprojectCriteriaOrNull;

    public static ListSampleDisplayCriteria2 createForContainer(TechId containerSampleId) {
        return new ListSampleDisplayCriteria2(ListSampleCriteria.createForContainer(containerSampleId));
    }

    public static ListSampleDisplayCriteria2 createForParent(TechId parentSampleId) {
        return new ListSampleDisplayCriteria2(ListSampleCriteria.createForParent(parentSampleId));
    }

    public static ListSampleDisplayCriteria2 createForChild(TechId childSampleId) {
        return new ListSampleDisplayCriteria2(ListSampleCriteria.createForChild(childSampleId));
    }

    public static ListSampleDisplayCriteria2 createForExperiment(TechId experimentId) {
        return new ListSampleDisplayCriteria2(ListSampleCriteria.createForExperiment(experimentId));
    }

    public static ListSampleDisplayCriteria2 createForSearch() {
        return ListSampleDisplayCriteria2.createForSearch(new DetailedSearchCriteria());
    }

    private static ListSampleDisplayCriteria2 createForSearch(DetailedSearchCriteria searchCriteria) {
        return new ListSampleDisplayCriteria2(searchCriteria);
    }

    public ListSampleDisplayCriteria2(DetailedSearchCriteria searchCriteria) {
        assert (searchCriteria != null) : "search criteria not set";
        this.criteriaKind = ListEntityDisplayCriteriaKind.SEARCH;
        this.setSearchCriteriaOrNull(searchCriteria);
    }

    public ListSampleDisplayCriteria2(ListSampleCriteria listCriteria) {
        assert (listCriteria != null) : "list criteria not set";
        this.criteriaKind = ListEntityDisplayCriteriaKind.BROWSE;
        this.setListCriteriaOrNull(listCriteria);
    }

    public ListSampleDisplayCriteria2(MetaprojectCriteria metaprojectCriteria) {
        assert (metaprojectCriteria != null) : "metaproject criteria not set";
        this.criteriaKind = ListEntityDisplayCriteriaKind.METAPROJECT;
        this.setMetaprojectCriteriaOrNull(metaprojectCriteria);
    }

    public ListEntityDisplayCriteriaKind getCriteriaKind() {
        return this.criteriaKind;
    }

    public ListSampleCriteria getBrowseCriteria() {
        assert (this.getCriteriaKind() == ListEntityDisplayCriteriaKind.BROWSE) : "not a browse criteria";
        return this.getListCriteriaOrNull();
    }

    public DetailedSearchCriteria getSearchCriteria() {
        assert (this.getCriteriaKind() == ListEntityDisplayCriteriaKind.SEARCH) : "not a search criteria";
        return this.getSearchCriteriaOrNull();
    }

    public MetaprojectCriteria getMetaprojectCriteria() {
        assert (this.getCriteriaKind() == ListEntityDisplayCriteriaKind.METAPROJECT) : "not a metaproject criteria";
        return this.getMetaprojectCriteriaOrNull();
    }

    public void updateSearchCriteria(DetailedSearchCriteria newSearchCriteria) {
        assert (this.getCriteriaKind() == ListEntityDisplayCriteriaKind.SEARCH) : "not a search criteria";
        assert (newSearchCriteria != null) : "new search criteria not set";
        this.setSearchCriteriaOrNull(newSearchCriteria);
    }

    private ListSampleCriteria getListCriteriaOrNull() {
        return this.listCriteriaOrNull;
    }

    private void setListCriteriaOrNull(ListSampleCriteria listCriteriaOrNull) {
        this.listCriteriaOrNull = listCriteriaOrNull;
    }

    private DetailedSearchCriteria getSearchCriteriaOrNull() {
        return this.searchCriteriaOrNull;
    }

    private void setSearchCriteriaOrNull(DetailedSearchCriteria searchCriteriaOrNull) {
        this.searchCriteriaOrNull = searchCriteriaOrNull;
    }

    public MetaprojectCriteria getMetaprojectCriteriaOrNull() {
        return this.metaprojectCriteriaOrNull;
    }

    public void setMetaprojectCriteriaOrNull(MetaprojectCriteria metaprojectCriteriaOrNull) {
        this.metaprojectCriteriaOrNull = metaprojectCriteriaOrNull;
    }

    public void setAllSampleType(SampleType sampleType) {
        this.allSampleTypeOrNull = sampleType;
    }

    public SampleType tryGetSampleType() {
        if (this.allSampleTypeOrNull != null) {
            return this.allSampleTypeOrNull;
        }
        return this.listCriteriaOrNull != null ? this.listCriteriaOrNull.getSampleType() : null;
    }

    private ListSampleDisplayCriteria2() {
    }
}

