/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.client.web.client.IClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.UserFailureExceptionTranslator;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.RootClassFilter;

public class ClientServiceExceptionTranslatingAdvisor
extends DefaultPointcutAdvisor {
    private static final long serialVersionUID = 1L;

    public ClientServiceExceptionTranslatingAdvisor() {
        super((Pointcut)new AllClientServiceMethodsPointcut(), (Advice)new UserFailureExceptionTranslatingInterceptor());
    }

    private static class AllClientServiceMethodsPointcut
    implements Pointcut {
        private AllClientServiceMethodsPointcut() {
        }

        public MethodMatcher getMethodMatcher() {
            return MethodMatcher.TRUE;
        }

        public ClassFilter getClassFilter() {
            return new RootClassFilter(IClientService.class);
        }
    }

    private static class UserFailureExceptionTranslatingInterceptor
    implements MethodInterceptor {
        private UserFailureExceptionTranslatingInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            try {
                return invocation.proceed();
            }
            catch (UserFailureException ex) {
                throw UserFailureExceptionTranslator.translate(ex);
            }
        }
    }
}

