/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractFileDownloadServlet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/template-download", "/openbis/template-download"})
public class FileTemplateServiceServlet
extends AbstractFileDownloadServlet {
    @Resource(name="common-service")
    private ICommonClientService service;

    @Override
    protected AbstractFileDownloadServlet.FileContent getFileContent(HttpServletRequest request) throws Exception {
        String kind = request.getParameter("entityKind");
        String type = request.getParameter("entityType");
        String autoGenerate = request.getParameter("autoGenerate");
        String withExperimentsParameter = request.getParameter("with_experiments");
        boolean withExperiments = withExperimentsParameter != null && Boolean.parseBoolean(withExperimentsParameter);
        String withSapceParameter = request.getParameter("with_space");
        boolean withSpace = withSapceParameter == null || Boolean.parseBoolean(withSapceParameter);
        String operationKindParameter = request.getParameter("batch_operation_kind");
        BatchOperationKind operationKind = BatchOperationKind.valueOf(operationKindParameter);
        if (StringUtils.isNotBlank((String)kind) && StringUtils.isNotBlank((String)type)) {
            String fileContent = this.service.getTemplate(EntityKind.valueOf(kind), type, Boolean.parseBoolean(autoGenerate), withExperiments, withSpace, operationKind);
            byte[] value = fileContent.getBytes();
            String fileName = String.valueOf(kind) + "-" + type + "-template.tsv";
            return new AbstractFileDownloadServlet.FileContent(value, fileName);
        }
        return null;
    }
}

