/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.DeletionUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSetUrl;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumnGroup;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public abstract class AbstractExternalDataProvider
extends AbstractCommonTableModelProvider<AbstractExternalData> {
    public AbstractExternalDataProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<AbstractExternalData> createTableModel() {
        List<AbstractExternalData> dataSets = this.getDataSets();
        TypedTableModelBuilder<AbstractExternalData> builder = new TypedTableModelBuilder<AbstractExternalData>();
        builder.addColumn("CODE").withDefaultWidth(150);
        builder.addColumn("EXTERNAL_CODE").withDefaultWidth(150).hideByDefault();
        builder.addColumn("DATA_SET_TYPE").withDefaultWidth(200);
        builder.addColumn("CONTAINER_DATASET").withDefaultWidth(150).hideByDefault();
        builder.addColumn("ORDER_IN_CONTAINER").withDefaultWidth(100).hideByDefault();
        builder.addColumn("PARENT_DATASETS").withDefaultWidth(150).hideByDefault();
        builder.addColumn("SAMPLE").withDefaultWidth(100).hideByDefault();
        builder.addColumn("EXTERNAL_DATA_SAMPLE_IDENTIFIER").withDefaultWidth(200);
        builder.addColumn("SAMPLE_TYPE");
        builder.addColumn("EXPERIMENT").withDefaultWidth(100).hideByDefault();
        builder.addColumn("EXTERNAL_DATA_EXPERIMENT_IDENTIFIER").withDefaultWidth(100).hideByDefault();
        builder.addColumn("EXPERIMENT_TYPE").withDefaultWidth(120).hideByDefault();
        builder.addColumn("PROJECT");
        builder.addColumn("REGISTRATOR");
        builder.addColumn("MODIFIER");
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(200);
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(200).hideByDefault();
        builder.addColumn("IS_DELETED").hideByDefault();
        builder.addColumn("SOURCE_TYPE").hideByDefault();
        builder.addColumn("IS_COMPLETE").hideByDefault();
        builder.addColumn("LOCATION").hideByDefault();
        builder.addColumn("ARCHIVING_STATUS").withDefaultWidth(200).hideByDefault();
        builder.addColumn("FILE_FORMAT_TYPE").hideByDefault();
        builder.addColumn("PRODUCTION_DATE").withDefaultWidth(200).hideByDefault();
        builder.addColumn("DATA_PRODUCER_CODE").hideByDefault();
        builder.addColumn("DATA_STORE_CODE").hideByDefault();
        builder.addColumn("EXTERNAL_DMS_CODE").withDefaultWidth(150).hideByDefault();
        builder.addColumn("EXTERNAL_DMS_LABEL").withDefaultWidth(150).hideByDefault();
        builder.addColumn("PERM_ID").hideByDefault();
        builder.addColumn("SHOW_DETAILS_LINK").hideByDefault();
        builder.addColumn("METAPROJECTS");
        for (AbstractExternalData dataSet : dataSets) {
            Experiment experiment;
            builder.addRow(dataSet);
            if (dataSet.isStub()) {
                builder.column("PERM_ID").addString(dataSet.getPermId());
                continue;
            }
            builder.column("CODE").addEntityLink(dataSet, dataSet.getCode());
            LinkDataSet linkDataSet = dataSet.tryGetAsLinkDataSet();
            if (linkDataSet != null) {
                LinkTableCell externalCodeCell = new LinkTableCell();
                externalCodeCell.setText(linkDataSet.getExternalCode());
                externalCodeCell.setUrl(new LinkDataSetUrl(linkDataSet).toString());
                externalCodeCell.setOpenInNewWindow(true);
                builder.column("EXTERNAL_CODE").addValue(externalCodeCell);
                ExternalDataManagementSystem externalDms = linkDataSet.getExternalDataManagementSystem();
                if (externalDms != null) {
                    builder.column("EXTERNAL_DMS_CODE").addString(externalDms.getCode());
                    builder.column("EXTERNAL_DMS_LABEL").addString(externalDms.getLabel());
                }
            }
            builder.column("METAPROJECTS").addString(this.metaProjectsToString(dataSet.getMetaprojects()));
            builder.column("DATA_SET_TYPE").addString(dataSet.getDataSetType().getCode());
            ContainerDataSet container = dataSet.tryGetContainer();
            if (container != null) {
                builder.column("CONTAINER_DATASET").addEntityLink(container, container.getCode());
            }
            Integer orderInContainer = dataSet.getOrderInContainer();
            builder.column("ORDER_IN_CONTAINER").addString(orderInContainer == null ? "" : orderInContainer.toString());
            builder.column("PARENT_DATASETS").addEntityLink(dataSet.getParents());
            Sample sample = dataSet.getSample();
            if (sample != null) {
                builder.column("SAMPLE").addEntityLink(sample, sample.getCode());
                builder.column("EXTERNAL_DATA_SAMPLE_IDENTIFIER").addEntityLink(sample, sample.getIdentifier());
                SampleType sampleType = dataSet.getSampleType();
                builder.column("SAMPLE_TYPE").addString(sampleType.getCode());
            }
            if ((experiment = dataSet.getExperiment()) != null) {
                builder.column("EXPERIMENT").addEntityLink(experiment, experiment.getCode());
                builder.column("EXTERNAL_DATA_EXPERIMENT_IDENTIFIER").addEntityLink(experiment, experiment.getIdentifier());
                builder.column("EXPERIMENT_TYPE").addString(experiment.getEntityType().getCode());
                builder.column("PROJECT").addString(experiment.getProject().getCode());
            }
            builder.column("REGISTRATOR").addPerson(dataSet.getRegistrator());
            builder.column("MODIFIER").addPerson(dataSet.getModifier());
            builder.column("REGISTRATION_DATE").addDate(dataSet.getRegistrationDate());
            builder.column("MODIFICATION_DATE").addDate(dataSet.getModificationDate());
            builder.column("IS_DELETED").addString(SimpleYesNoRenderer.render(DeletionUtils.isDeleted(dataSet)));
            builder.column("SOURCE_TYPE").addString(dataSet.getSourceType());
            if (dataSet instanceof PhysicalDataSet) {
                PhysicalDataSet realDataSet = (PhysicalDataSet)dataSet;
                Boolean complete = realDataSet.getComplete();
                builder.column("IS_COMPLETE").addString(complete == null ? "?" : SimpleYesNoRenderer.render(complete));
                builder.column("LOCATION").addString(realDataSet.getFullLocation());
                builder.column("ARCHIVING_STATUS").addString(realDataSet.getStatus().getDescription());
                builder.column("PRESENT_IN_ARCHIVE").addString(SimpleYesNoRenderer.render(realDataSet.isPresentInArchive()));
                FileFormatType fileFormatType = realDataSet.getFileFormatType();
                builder.column("FILE_FORMAT_TYPE").addString(fileFormatType == null ? "" : fileFormatType.getCode());
                builder.column("STORAGE_CONFIRMATION").addString(SimpleYesNoRenderer.render(dataSet.isStorageConfirmation()));
            }
            builder.column("PRODUCTION_DATE").addDate(dataSet.getProductionDate());
            builder.column("DATA_PRODUCER_CODE").addString(dataSet.getDataProducerCode());
            builder.column("DATA_STORE_CODE").addString(dataSet.getDataStore().getCode());
            builder.column("PERM_ID").addString(dataSet.getPermId());
            builder.column("SHOW_DETAILS_LINK").addString(dataSet.getPermlink());
            IColumnGroup columnGroup = builder.columnGroup("property-");
            DataSetType dataSetType = dataSet.getDataSetType();
            if (dataSetType != null) {
                columnGroup.addColumnsForAssignedProperties(dataSetType);
            }
            columnGroup.addProperties(dataSet.getProperties());
        }
        return builder.getModel();
    }

    protected abstract List<AbstractExternalData> getDataSets();
}

