/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentVersions;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AttachmentVersionsProvider
extends AbstractCommonTableModelProvider<AttachmentVersions> {
    private final TechId holderId;
    private final AttachmentHolderKind holderKind;

    public AttachmentVersionsProvider(ICommonServer commonServer, String sessionToken, TechId holderId, AttachmentHolderKind holderKind) {
        super(commonServer, sessionToken);
        this.holderId = holderId;
        this.holderKind = holderKind;
    }

    @Override
    protected TypedTableModel<AttachmentVersions> createTableModel() {
        List<Attachment> attachments = this.listAttachments();
        TypedTableModelBuilder<AttachmentVersions> builder = new TypedTableModelBuilder<AttachmentVersions>();
        builder.addColumn("FILE_NAME").withDefaultWidth(200);
        builder.addColumn("PERMLINK");
        builder.addColumn("VERSION");
        builder.addColumn("TITLE").withDefaultWidth(200);
        builder.addColumn("DESCRIPTION").withDefaultWidth(300);
        builder.addColumn("REGISTRATOR");
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(300);
        for (AttachmentVersions versions : this.convert(attachments)) {
            builder.addRow(versions);
            builder.column("FILE_NAME").addString(versions.getCurrent().getFileName());
            builder.column("PERMLINK").addString(versions.getLatestVersionPermlink());
            builder.column("VERSION").addInteger(Long.valueOf(versions.getCurrent().getVersion()));
            builder.column("TITLE").addString(versions.getCurrent().getTitle());
            builder.column("DESCRIPTION").addString(versions.getCurrent().getDescription());
            builder.column("REGISTRATOR").addPerson(versions.getCurrent().getRegistrator());
            builder.column("REGISTRATION_DATE").addDate(versions.getCurrent().getRegistrationDate());
        }
        return builder.getModel();
    }

    private List<Attachment> listAttachments() {
        List<Attachment> attachments = null;
        switch (this.holderKind) {
            case EXPERIMENT: {
                attachments = this.commonServer.listExperimentAttachments(this.sessionToken, this.holderId);
                break;
            }
            case SAMPLE: {
                attachments = this.commonServer.listSampleAttachments(this.sessionToken, this.holderId);
                break;
            }
            case PROJECT: {
                attachments = this.commonServer.listProjectAttachments(this.sessionToken, this.holderId);
            }
        }
        return attachments;
    }

    private List<AttachmentVersions> convert(List<Attachment> attachments) {
        HashMap map = new HashMap();
        for (Attachment a : attachments) {
            if (!map.containsKey(a.getFileName())) {
                map.put(a.getFileName(), new ArrayList());
            }
            ((List)map.get(a.getFileName())).add(a);
        }
        ArrayList<AttachmentVersions> result = new ArrayList<AttachmentVersions>(map.size());
        for (List versions : map.values()) {
            result.add(new AttachmentVersions(versions));
        }
        return result;
    }
}

