/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.shared.basic.string.AlternativesStringFilter;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ColumnDistinctValues;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.CustomFilterInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridColumnFilterInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridCustomColumnInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridFilters;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetFetchConfig;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.GridExpressionUtils;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.ITableDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ColumnSortUtils;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.DefaultResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ICustomColumnsProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IOriginalDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSetKeyGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSetManager;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.TableDataProviderFactory;
import ch.systemsx.cisd.openbis.generic.client.web.server.util.XMLPropertyTransformer;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SortInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableGridColumnDefinition;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public final class CachedResultSetManager<K>
implements IResultSetManager<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Private
    static final int MAX_DISTINCT_COLUMN_VALUES_SIZE = 50;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, CachedResultSetManager.class);
    private final IResultSetKeyGenerator<K> resultSetKeyProvider;
    private final ICustomColumnsProvider customColumnsProvider;
    private final Map<K, Future<?>> cache = Collections.synchronizedMap(new HashMap());
    private final Set<K> lockedResultSets = Collections.synchronizedSet(new HashSet());
    private final ThreadPoolExecutor executor = new NamingThreadPoolExecutor("Background Table Loader").corePoolSize(10).daemonize();
    private final XMLPropertyTransformer xmlPropertyTransformer = new XMLPropertyTransformer();
    private final IColumnCalculator columnCalculator;

    private static final GridCustomColumnInfo translate(GridCustomColumn columnDefinition) {
        return new GridCustomColumnInfo(columnDefinition.getCode(), columnDefinition.getName(), columnDefinition.getDescription(), columnDefinition.getDataType());
    }

    private static <T> String getOriginalValue(IColumnDefinition<T> definition, GridRowModel<T> row) {
        Comparable<?> value = definition.tryGetComparableValue(row);
        if (value != null && value instanceof DateTableCell) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date d = ((DateTableCell)value).getDateTime();
            return df.format(d);
        }
        return value == null ? "" : value.toString();
    }

    public CachedResultSetManager(IResultSetKeyGenerator<K> resultSetKeyProvider, ICustomColumnsProvider customColumnsProvider) {
        this(resultSetKeyProvider, customColumnsProvider, new IColumnCalculator(){

            @Override
            public <T> List<PrimitiveValue> evalCustomColumn(List<T> data, GridCustomColumn customColumn, Set<IColumnDefinition<T>> availableColumns, boolean errorMessagesAreLong) {
                return GridExpressionUtils.evalCustomColumn(TableDataProviderFactory.createDataProvider(data, new ArrayList<IColumnDefinition<T>>(availableColumns)), customColumn, errorMessagesAreLong);
            }
        });
    }

    public CachedResultSetManager(IResultSetKeyGenerator<K> resultSetKeyProvider, ICustomColumnsProvider customColumnsProvider, IColumnCalculator columnCalculator) {
        this.resultSetKeyProvider = resultSetKeyProvider;
        this.customColumnsProvider = customColumnsProvider;
        this.columnCalculator = columnCalculator;
    }

    private static final <T> T cast(Object object) {
        return (T)object;
    }

    private static final <T> GridRowModels<T> filterData(GridRowModels<T> rows, Set<IColumnDefinition<T>> availableColumns, GridFilters<T> filters) {
        List<GridColumnFilterInfo<T>> filterInfos;
        List<GridRowModel<Object>> filteredRows = rows;
        CustomFilterInfo<T> customFilterInfo = filters.tryGetCustomFilterInfo();
        if (customFilterInfo != null) {
            long time = System.currentTimeMillis();
            ITableDataProvider dataProvider = TableDataProviderFactory.createDataProvider(rows, new ArrayList<IColumnDefinition<T>>(availableColumns));
            List<Integer> indices = GridExpressionUtils.applyCustomFilter(dataProvider, customFilterInfo);
            filteredRows = new ArrayList();
            for (Integer index : indices) {
                filteredRows.add((GridRowModel)rows.get(index));
            }
            operationLog.info((Object)(String.valueOf(System.currentTimeMillis() - time) + "ms for filtering " + rows.size() + " rows with custom filter '" + customFilterInfo.getName() + "'."));
        }
        if ((filterInfos = filters.tryGetFilterInfos()) != null) {
            filteredRows = CachedResultSetManager.applyStandardColumnFilter(rows, filterInfos);
        }
        return rows.cloneWithData(filteredRows);
    }

    private static <T> List<GridRowModel<T>> applyStandardColumnFilter(GridRowModels<T> rows, List<GridColumnFilterInfo<T>> filterInfos) {
        ArrayList<GridRowModel<T>> filtered = new ArrayList<GridRowModel<T>>();
        List<FilterInfo<T>> appliedFilterInfos = CachedResultSetManager.processAppliedFilters(filterInfos);
        for (GridRowModel gridRowModel : rows) {
            if (!CachedResultSetManager.isMatching(gridRowModel, appliedFilterInfos)) continue;
            filtered.add(gridRowModel);
        }
        return filtered;
    }

    private static <T> List<FilterInfo<T>> processAppliedFilters(List<GridColumnFilterInfo<T>> filterInfos) {
        ArrayList<FilterInfo<T>> serverFilterInfos = new ArrayList<FilterInfo<T>>(filterInfos.size());
        for (GridColumnFilterInfo<T> filterInfo : filterInfos) {
            FilterInfo<T> info = FilterInfo.tryCreate(filterInfo);
            if (info == null) continue;
            serverFilterInfos.add(info);
        }
        return serverFilterInfos;
    }

    private static final <T> boolean isMatching(GridRowModel<T> row, List<FilterInfo<T>> serverFilterInfos) {
        for (FilterInfo<T> filter : serverFilterInfos) {
            if (filter.isMatching(row)) continue;
            return false;
        }
        return true;
    }

    private static <T> void sortData(GridRowModels<T> data, SortInfo sortInfo, Set<IColumnDefinition<T>> availableColumns) {
        assert (data != null) : "Unspecified data.";
        assert (sortInfo != null) : "Unspecified sort information.";
        if (data.size() == 0) {
            return;
        }
        SortInfo.SortDir sortDir = sortInfo.getSortDir();
        String sortField = sortInfo.getSortField();
        if (sortDir == SortInfo.SortDir.NONE || sortField == null) {
            return;
        }
        IColumnDefinition<T> sortFieldDefinition = null;
        for (IColumnDefinition<T> column : availableColumns) {
            if (!sortField.equals(column.getIdentifier())) continue;
            sortFieldDefinition = column;
            Comparator<GridRowModel<T>> comparator = ColumnSortUtils.createComparator(sortDir, sortFieldDefinition);
            Collections.sort(data, comparator);
            break;
        }
    }

    private static int getLimit(int size, int limit, int offset) {
        assert (size > -1) : "Size can not be negative";
        if (limit < 0) {
            return size - offset;
        }
        return Math.min(size - offset, limit);
    }

    private static int getOffset(int size, int offset) {
        assert (size > -1) : "Size can not be negative";
        if (size == 0) {
            return 0;
        }
        return Math.min(size - 1, Math.max(offset, 0));
    }

    private static final <T> GridRowModels<T> subList(GridRowModels<T> data, int offset, int limit) {
        int toIndex = offset + limit;
        return data.cloneWithData(data.subList(offset, toIndex));
    }

    @Override
    public final <T> IResultSet<K, T> getResultSet(String sessionToken, IResultSetConfig<K, T> resultConfig, IOriginalDataProvider<T> dataProvider) {
        IResultSet<K, T> cachedResultSet = this.getRawResultSet(sessionToken, resultConfig, dataProvider);
        return cachedResultSet;
    }

    private final <T> IResultSet<K, T> getRawResultSet(String sessionToken, IResultSetConfig<K, T> resultConfig, IOriginalDataProvider<T> dataProvider) {
        assert (resultConfig != null) : "Unspecified result configuration";
        assert (dataProvider != null) : "Unspecified data retriever";
        ResultSetFetchConfig<K> cacheConfig = resultConfig.getCacheConfig();
        ResultSetFetchConfig.ResultSetFetchMode mode = cacheConfig.getMode();
        this.debug("getResultSet(cache config = " + cacheConfig + ")");
        K dataKey = cacheConfig.tryGetResultSetKey();
        switch (mode) {
            case RECOMPUTE_AND_CACHE: {
                return this.fetchAndCacheResultForSpecifiedKey(sessionToken, resultConfig, dataProvider, dataKey);
            }
            case CLEAR_COMPUTE_AND_CACHE: {
                this.removeResultSet(dataKey);
            }
            case COMPUTE_AND_CACHE: {
                return this.fetchAndCacheResult(sessionToken, resultConfig, dataProvider);
            }
        }
        TableData<T> tableData = this.tryGetCachedTableData(dataKey);
        if (tableData != null) {
            return CachedResultSetManager.calculateSortAndFilterResult(sessionToken, tableData, resultConfig, dataKey, false);
        }
        return this.fetchAndCacheResult(sessionToken, resultConfig, dataProvider);
    }

    private <T> IResultSet<K, T> fetchAndCacheResult(String sessionToken, IResultSetConfig<K, T> resultConfig, IOriginalDataProvider<T> dataProvider) {
        K dataKey = this.resultSetKeyProvider.createKey();
        return this.fetchAndCacheResultForSpecifiedKey(sessionToken, resultConfig, dataProvider, dataKey);
    }

    private <T> IResultSet<K, T> fetchAndCacheResultForSpecifiedKey(String sessionToken, IResultSetConfig<K, T> resultConfig, IOriginalDataProvider<T> dataProvider, K dataKey) {
        Future<TableData<T>> future;
        boolean partial;
        int limit = resultConfig.getLimit();
        if (limit == -1) {
            limit = Integer.MAX_VALUE;
        }
        this.debug("Retrieving " + limit + " record for a new key " + dataKey);
        List<T> rows = dataProvider.getOriginalData(limit);
        List<TableModelColumnHeader> headers = dataProvider.getHeaders();
        TableData<T> tableData = new TableData<T>(rows, headers, this.customColumnsProvider, this.columnCalculator);
        this.xmlPropertyTransformer.transformXMLProperties(rows);
        boolean bl = partial = rows.size() >= limit;
        if (partial) {
            this.debug("Only partially loaded data for key " + dataKey);
            future = this.loadCompleteTableInBackground(dataProvider, dataKey);
        } else {
            this.debug("Completely loaded for key " + dataKey);
            future = this.createFutureWhichIsPresent(dataKey, tableData);
        }
        this.addToCache(dataKey, future);
        return CachedResultSetManager.calculateSortAndFilterResult(sessionToken, tableData, this.createMatchingConfig(resultConfig, headers), dataKey, partial);
    }

    private <T> IResultSetConfig<K, T> createMatchingConfig(IResultSetConfig<K, T> resultSetConfig, List<TableModelColumnHeader> headers) {
        if (headers.isEmpty()) {
            return resultSetConfig;
        }
        if (this.hasNoStaleAvailableColumn(resultSetConfig, headers)) {
            return resultSetConfig;
        }
        HashSet newAvailableColumns = new HashSet();
        Set<String> idsOfPresentedColumns = resultSetConfig.getIDsOfPresentedColumns();
        HashSet<String> newIdsOfPresentedColumns = new HashSet<String>();
        SortInfo sortInfo = resultSetConfig.getSortInfo();
        TableMap<String, GridColumnFilterInfo<T>> columnFilterInfos = this.getColumFilters(resultSetConfig);
        ArrayList newColumnFilterInfos = new ArrayList();
        for (TableModelColumnHeader header : headers) {
            GridColumnFilterInfo<T> filterInfo;
            String sortField;
            TypedTableGridColumnDefinition definition = new TypedTableGridColumnDefinition(header, null, "", null);
            newAvailableColumns.add(definition);
            String id = header.getId();
            if (!header.isHidden() || idsOfPresentedColumns.contains(id)) {
                newIdsOfPresentedColumns.add(id);
            }
            if (sortInfo != null && (sortField = sortInfo.getSortField()) != null && sortField.equals(id)) {
                sortInfo.setSortField(id);
            }
            if ((filterInfo = columnFilterInfos.tryGet(id)) == null) continue;
            String pattern = filterInfo.tryGetFilterPattern();
            newColumnFilterInfos.add(new GridColumnFilterInfo(definition, pattern));
        }
        for (String id : idsOfPresentedColumns) {
            if (!id.startsWith("$")) continue;
            newIdsOfPresentedColumns.add(id);
        }
        DefaultResultSetConfig newConfig = new DefaultResultSetConfig();
        newConfig.setAvailableColumns(newAvailableColumns);
        newConfig.setCacheConfig(resultSetConfig.getCacheConfig());
        newConfig.setCustomColumnErrorMessageLong(resultSetConfig.isCustomColumnErrorMessageLong());
        GridFilters newFilters = newColumnFilterInfos.isEmpty() ? GridFilters.createEmptyFilter() : GridFilters.createColumnFilter(newColumnFilterInfos);
        newConfig.setFilters(newFilters);
        newConfig.setGridDisplayId(resultSetConfig.tryGetGridDisplayId());
        newConfig.setIDsOfPresentedColumns(newIdsOfPresentedColumns);
        newConfig.setLimit(resultSetConfig.getLimit());
        newConfig.setOffset(resultSetConfig.getOffset());
        newConfig.setSortInfo(sortInfo);
        return newConfig;
    }

    private <T> TableMap<String, GridColumnFilterInfo<T>> getColumFilters(IResultSetConfig<K, T> resultSetConfig) {
        GridFilters<T> filters = resultSetConfig.getFilters();
        List<GridColumnFilterInfo<T>> filterInfosOrNull = filters.tryGetFilterInfos();
        if (filterInfosOrNull == null) {
            filterInfosOrNull = Collections.emptyList();
        }
        TableMap<String, GridColumnFilterInfo<T>> columnFilterInfos = new TableMap<String, GridColumnFilterInfo<T>>(filterInfosOrNull, new IKeyExtractor<String, GridColumnFilterInfo<T>>(){

            @Override
            public String getKey(GridColumnFilterInfo<T> e) {
                return e.getFilteredField().getIdentifier();
            }
        });
        return columnFilterInfos;
    }

    private <T> boolean hasNoStaleAvailableColumn(IResultSetConfig<K, T> resultSetConfig, List<TableModelColumnHeader> headers) {
        HashSet<String> headerIds = new HashSet<String>();
        for (TableModelColumnHeader header : headers) {
            headerIds.add(header.getId());
        }
        Set<IColumnDefinition<T>> availableColumns = resultSetConfig.getAvailableColumns();
        if (availableColumns != null) {
            if (availableColumns.size() != headers.size()) {
                return false;
            }
            for (IColumnDefinition<T> definition : availableColumns) {
                if (headerIds.contains(definition.getIdentifier())) continue;
                return false;
            }
        }
        return true;
    }

    private <T> Future<TableData<T>> createFutureWhichIsPresent(K dataKey, final TableData<T> tableData) {
        return new Future<TableData<T>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public TableData<T> get() throws InterruptedException, ExecutionException {
                return tableData;
            }

            @Override
            public TableData<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }
        };
    }

    private <T> Future<TableData<T>> loadCompleteTableInBackground(final IOriginalDataProvider<T> dataProvider, final K dataKey) {
        Callable callable = new Callable<TableData<T>>(){

            @Override
            public TableData<T> call() throws Exception {
                List rows = dataProvider.getOriginalData(Integer.MAX_VALUE);
                List<TableModelColumnHeader> headers = dataProvider.getHeaders();
                CachedResultSetManager.this.debug(String.valueOf(rows.size()) + " records loaded for key " + dataKey);
                TableData tableData = new TableData(rows, headers, CachedResultSetManager.this.customColumnsProvider, CachedResultSetManager.this.columnCalculator);
                CachedResultSetManager.this.xmlPropertyTransformer.transformXMLProperties(rows);
                return tableData;
            }
        };
        Future<TableData<T>> future = this.executor.submit(callable);
        return future;
    }

    private <T> void addToCache(K dataKey, Future<TableData<T>> tableData) {
        this.unlockResultSet(dataKey);
        this.cache.put(dataKey, tableData);
        this.debug(String.valueOf(this.cache.size()) + " keys in cache: " + this.cache.keySet());
    }

    private static <K, T> IResultSet<K, T> calculateSortAndFilterResult(String sessionToken, TableData<T> tableData, IResultSetConfig<K, T> resultConfig, K dataKey, boolean partial) {
        GridRowModels<T> data = tableData.getRows(sessionToken, resultConfig);
        return CachedResultSetManager.filterLimitAndSort(resultConfig, data, dataKey, partial);
    }

    private <T> TableData<T> tryGetCachedTableData(K dataKey) {
        this.waitUntilUnlocked(dataKey);
        Future tableData = (Future)CachedResultSetManager.cast(this.cache.get(dataKey));
        if (tableData == null) {
            operationLog.warn((Object)("Reference to the stale cache key " + dataKey));
            return null;
        }
        try {
            return (TableData)tableData.get();
        }
        catch (InterruptedException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        catch (ExecutionException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)ex.getCause());
        }
    }

    private static <K, T> IResultSet<K, T> filterLimitAndSort(IResultSetConfig<K, T> resultConfig, GridRowModels<T> data, K dataKey, boolean partial) {
        GridRowModels<T> filteredData = CachedResultSetManager.filterData(data, resultConfig.getAvailableColumns(), resultConfig.getFilters());
        int size = filteredData.size();
        int offset = CachedResultSetManager.getOffset(size, resultConfig.getOffset());
        int limit = CachedResultSetManager.getLimit(size, resultConfig.getLimit(), offset);
        SortInfo sortInfo = resultConfig.getSortInfo();
        CachedResultSetManager.sortData(filteredData, sortInfo, resultConfig.getAvailableColumns());
        GridRowModels<T> list = CachedResultSetManager.subList(filteredData, offset, limit);
        return new DefaultResultSet<K, T>(dataKey, list, size, partial);
    }

    @Override
    public final void removeResultSet(K resultSetKey) {
        this.unlockResultSet(resultSetKey);
        assert (resultSetKey != null) : "Unspecified data key holder.";
        if (this.cache.remove(resultSetKey) != null) {
            this.debug(String.format("Result set for key '%s' has been removed.", resultSetKey));
        }
    }

    @Override
    public void lockResultSet(K resultSetKey) {
        this.lockedResultSets.add(resultSetKey);
    }

    private void unlockResultSet(K resultSetKey) {
        this.lockedResultSets.remove(resultSetKey);
    }

    private void waitUntilUnlocked(K resultSetKey) {
        while (this.lockedResultSets.contains(resultSetKey)) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                operationLog.error((Object)("Interrupted while waiting on unlocking " + resultSetKey), (Throwable)ex);
            }
        }
    }

    private void debug(String msg) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)msg);
        }
    }

    private static final class Column {
        private final GridCustomColumn columnDefinition;
        private List<PrimitiveValue> values;

        Column(GridCustomColumn columnDefinition) {
            this.columnDefinition = columnDefinition;
        }

        GridCustomColumnInfo getInfo() {
            return CachedResultSetManager.translate(this.columnDefinition);
        }

        boolean hasSameExpression(GridCustomColumn column) {
            return this.columnDefinition.getExpression().equals(column.getExpression());
        }

        public void setValues(List<PrimitiveValue> values) {
            this.values = values;
        }

        public List<PrimitiveValue> getValues() {
            return this.values;
        }
    }

    private static class FilterInfo<T> {
        private final IColumnDefinition<T> filteredField;
        private final AlternativesStringFilter filter;

        private FilterInfo(GridColumnFilterInfo<T> gridFilterInfo) {
            this.filteredField = gridFilterInfo.getFilteredField();
            this.filter = this.createAlternativesFilter(gridFilterInfo);
        }

        private AlternativesStringFilter createAlternativesFilter(GridColumnFilterInfo<T> gridFilterInfo) {
            AlternativesStringFilter result = new AlternativesStringFilter();
            String pattern = gridFilterInfo.tryGetFilterPattern().toLowerCase();
            if (DataTypeCode.TIMESTAMP.equals(gridFilterInfo.getFilteredField().tryToGetDataType())) {
                result.setDateFilterValue(pattern);
            } else {
                result.setFilterValue(pattern);
            }
            return result;
        }

        static <T> FilterInfo<T> tryCreate(GridColumnFilterInfo<T> filterInfo) {
            if (filterInfo.tryGetFilterPattern() == null) {
                return null;
            }
            return new FilterInfo<T>(filterInfo);
        }

        public boolean isMatching(GridRowModel<T> row) {
            IColumnDefinition<T> definition = this.filteredField;
            String value = CachedResultSetManager.getOriginalValue(definition, row).toLowerCase();
            return this.filter.passes(value);
        }
    }

    static interface IColumnCalculator {
        public <T> List<PrimitiveValue> evalCustomColumn(List<T> var1, GridCustomColumn var2, Set<IColumnDefinition<T>> var3, boolean var4);
    }

    private static class TableData<T> {
        private final List<T> originalData;
        private final ICustomColumnsProvider customColumnsProvider;
        private final IColumnCalculator columnCalculator;
        private final List<TableModelColumnHeader> headers;
        private final List<IColumnDefinition<T>> headerColumnDefinitions = new ArrayList<IColumnDefinition<T>>();
        private Map<String, Column> calculatedColumns = new HashMap<String, Column>();

        TableData(List<T> originalData, List<TableModelColumnHeader> headers, ICustomColumnsProvider customColumnsProvider, IColumnCalculator columnCalculator) {
            this.originalData = originalData;
            this.headers = headers;
            for (final TableModelColumnHeader header : headers) {
                this.headerColumnDefinitions.add(new IColumnDefinition<T>(){

                    @Override
                    public String getValue(GridRowModel<T> rowModel) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Comparable<?> tryGetComparableValue(GridRowModel<T> rowModel) {
                        Object originalObject = rowModel.getOriginalObject();
                        if (originalObject instanceof TableModelRow) {
                            TableModelRow row = (TableModelRow)originalObject;
                            return row.getValues().get(header.getIndex());
                        }
                        return null;
                    }

                    @Override
                    public String getHeader() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public String getIdentifier() {
                        return header.getId();
                    }

                    @Override
                    public DataTypeCode tryToGetDataType() {
                        return null;
                    }

                    @Override
                    public String tryToGetProperty(String key) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean isCustom() {
                        return false;
                    }
                });
            }
            this.customColumnsProvider = customColumnsProvider;
            this.columnCalculator = columnCalculator;
        }

        GridRowModels<T> getRows(String sessionToken, IResultSetConfig<?, T> config) {
            Set<Map.Entry<String, Column>> cachedColumns = this.calculatedColumns.entrySet();
            List<GridCustomColumn> allCustomColumnDefinitions = this.loadAllCustomColumnDefinitions(sessionToken, config);
            List<GridCustomColumn> neededCustomColumns = this.filterNeededCustomColumnDefinitions(allCustomColumnDefinitions, config);
            this.removedColumnsNoLongerNeeded(cachedColumns, neededCustomColumns);
            for (GridCustomColumn customColumn : neededCustomColumns) {
                String code = customColumn.getCode();
                Column column = this.calculatedColumns.get(code);
                if (column != null) continue;
                Set<IColumnDefinition<T>> availableColumns = this.getAvailableColumns(config);
                boolean errorMessageLong = config.isCustomColumnErrorMessageLong();
                long time = System.currentTimeMillis();
                List<PrimitiveValue> values = this.columnCalculator.evalCustomColumn(this.originalData, customColumn, availableColumns, errorMessageLong);
                operationLog.info((Object)(String.valueOf(System.currentTimeMillis() - time) + "ms for calculating column '" + customColumn.getName() + "' over " + this.originalData.size() + " rows."));
                column = new Column(customColumn);
                column.setValues(values);
                this.calculatedColumns.put(code, column);
            }
            ArrayList<GridRowModel<T>> rows = new ArrayList<GridRowModel<T>>();
            int i = 0;
            while (i < this.originalData.size()) {
                T rowData = this.originalData.get(i);
                HashMap<String, PrimitiveValue> customColumnValues = new HashMap<String, PrimitiveValue>();
                for (Map.Entry<String, Column> entry : cachedColumns) {
                    String columnCode = entry.getKey();
                    customColumnValues.put(columnCode, entry.getValue().getValues().get(i));
                }
                rows.add(new GridRowModel<T>(rowData, customColumnValues));
                ++i;
            }
            List<ColumnDistinctValues> columnDistinctValues = this.calculateColumnDistinctValues(rows, config.getFilters());
            List<GridCustomColumnInfo> customColumnInfos = this.extractColumnInfos(allCustomColumnDefinitions);
            return new GridRowModels<T>(rows, this.headers, customColumnInfos, columnDistinctValues);
        }

        private Set<IColumnDefinition<T>> getAvailableColumns(IResultSetConfig<?, T> config) {
            HashSet<IColumnDefinition<T>> columns = new HashSet<IColumnDefinition<T>>();
            HashSet<String> columnIDs = new HashSet<String>();
            for (IColumnDefinition<T> definition : this.headerColumnDefinitions) {
                columns.add(definition);
                columnIDs.add(definition.getIdentifier());
            }
            Set<IColumnDefinition<T>> columnsFromConfig = config.getAvailableColumns();
            for (IColumnDefinition<T> definition : columnsFromConfig) {
                if (columnIDs.contains(definition.getIdentifier())) continue;
                columns.add(definition);
            }
            return columns;
        }

        private List<GridCustomColumn> loadAllCustomColumnDefinitions(String sessionToken, IResultSetConfig<?, T> resultConfig) {
            String gridId = resultConfig.tryGetGridDisplayId();
            ArrayList<GridCustomColumn> result = new ArrayList<GridCustomColumn>();
            if (gridId != null) {
                List<GridCustomColumn> columns = this.customColumnsProvider.getGridCustomColumn(sessionToken, gridId);
                for (GridCustomColumn column : columns) {
                    result.add(column);
                }
            }
            return result;
        }

        private List<GridCustomColumn> filterNeededCustomColumnDefinitions(List<GridCustomColumn> allDefinitions, IResultSetConfig<?, T> resultConfig) {
            Set<String> ids = this.gatherAllColumnIDs(resultConfig);
            ArrayList<GridCustomColumn> result = new ArrayList<GridCustomColumn>();
            for (GridCustomColumn column : allDefinitions) {
                if (!ids.contains(column.getCode())) continue;
                result.add(column);
            }
            return result;
        }

        private Set<String> gatherAllColumnIDs(IResultSetConfig<?, T> resultConfig) {
            CustomFilterInfo<T> customFilterInfo;
            GridFilters<T> filters;
            List<GridColumnFilterInfo<T>> filterInfos;
            String sortField;
            HashSet<String> ids = new HashSet<String>();
            Set<String> idsOfPresentedColumns = resultConfig.getIDsOfPresentedColumns();
            if (idsOfPresentedColumns != null) {
                ids.addAll(idsOfPresentedColumns);
            }
            if ((sortField = resultConfig.getSortInfo().getSortField()) != null) {
                ids.add(sortField);
            }
            if ((filterInfos = (filters = resultConfig.getFilters()).tryGetFilterInfos()) != null) {
                for (GridColumnFilterInfo<T> filterInfo : filterInfos) {
                    ids.add(filterInfo.getFilteredField().getIdentifier());
                }
            }
            if ((customFilterInfo = filters.tryGetCustomFilterInfo()) != null) {
                String expression = customFilterInfo.getExpression();
                Set<IColumnDefinition<T>> availableColumns = resultConfig.getAvailableColumns();
                for (IColumnDefinition<T> columnDefinition : availableColumns) {
                    String identifier = columnDefinition.getIdentifier();
                    if (expression.indexOf(identifier) < 0) continue;
                    ids.add(identifier);
                }
            }
            return ids;
        }

        private void removedColumnsNoLongerNeeded(Set<Map.Entry<String, Column>> cachedColumns, List<GridCustomColumn> neededCustomColumns) {
            HashMap<String, GridCustomColumn> map = new HashMap<String, GridCustomColumn>();
            for (GridCustomColumn customColumn : neededCustomColumns) {
                map.put(customColumn.getCode(), customColumn);
            }
            Iterator<Map.Entry<String, Column>> iterator = cachedColumns.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Column> entry = iterator.next();
                String code = entry.getKey();
                GridCustomColumn customColumn = (GridCustomColumn)map.get(code);
                if (customColumn == null) {
                    iterator.remove();
                    continue;
                }
                if (entry.getValue().hasSameExpression(customColumn)) continue;
                iterator.remove();
            }
        }

        private List<ColumnDistinctValues> calculateColumnDistinctValues(List<GridRowModel<T>> rowModels, GridFilters<T> gridFilters) {
            ArrayList<ColumnDistinctValues> result = new ArrayList<ColumnDistinctValues>();
            List<GridColumnFilterInfo<T>> filterInfos = gridFilters.tryGetFilterInfos();
            if (filterInfos == null) {
                return result;
            }
            for (GridColumnFilterInfo<T> column : filterInfos) {
                ColumnDistinctValues distinctValues = this.tryCalculateColumnDistinctValues(rowModels, column.getFilteredField());
                if (distinctValues == null) continue;
                result.add(distinctValues);
            }
            return result;
        }

        private ColumnDistinctValues tryCalculateColumnDistinctValues(List<GridRowModel<T>> rowModels, IColumnDefinition<T> column) {
            LinkedHashSet<String> distinctValues = new LinkedHashSet<String>();
            for (GridRowModel<T> rowModel : rowModels) {
                String value = CachedResultSetManager.getOriginalValue(column, rowModel);
                distinctValues.add(value);
                if (distinctValues.size() <= 50) continue;
                return null;
            }
            ArrayList<String> distinctValuesList = new ArrayList<String>(distinctValues);
            return new ColumnDistinctValues(column.getIdentifier(), distinctValuesList);
        }

        private List<GridCustomColumnInfo> extractColumnInfos(List<GridCustomColumn> allCustomColumnDefinitions) {
            ArrayList<GridCustomColumnInfo> result = new ArrayList<GridCustomColumnInfo>();
            for (GridCustomColumn definition : allCustomColumnDefinitions) {
                Column column = this.calculatedColumns.get(definition.getCode());
                if (column != null) {
                    result.add(column.getInfo());
                    continue;
                }
                result.add(CachedResultSetManager.translate(definition));
            }
            return result;
        }
    }
}

