/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AlphanumComparator;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SortInfo;
import java.util.Comparator;
import org.apache.commons.collections.ComparatorUtils;

class ColumnSortUtils {
    private static final Comparator<String> alphanumComparator = new AlphanumComparator();

    ColumnSortUtils() {
    }

    static <T> Comparator<GridRowModel<T>> createComparator(SortInfo.SortDir sortDir, IColumnDefinition<T> sortField) {
        Comparator<GridRowModel<T>> comparator = ColumnSortUtils.isAlphanum(sortField) ? ColumnSortUtils.createAlphanumComparator(sortField) : ColumnSortUtils.createDefaultComparator(sortField);
        return ColumnSortUtils.applySortDir(sortDir, comparator);
    }

    private static <T> boolean isAlphanum(IColumnDefinition<T> field) {
        return field.getIdentifier().contains("CODE") || field.getIdentifier().contains("IDENTIFIER");
    }

    private static <T> Comparator<GridRowModel<T>> createDefaultComparator(IColumnDefinition<T> sortField) {
        return new GridRowModelComparator(sortField);
    }

    private static <T> Comparator<GridRowModel<T>> createAlphanumComparator(IColumnDefinition<T> sortField) {
        return new GridRowModelComparator<T>(sortField){

            @Override
            protected int compare(Comparable v1, Comparable v2) {
                return alphanumComparator.compare(v1.toString(), v2.toString());
            }
        };
    }

    private static <T> Comparator<T> applySortDir(SortInfo.SortDir sortDir, Comparator<T> comparator) {
        if (sortDir == SortInfo.SortDir.DESC) {
            return ComparatorUtils.reversedComparator(comparator);
        }
        return comparator;
    }

    private static class GridRowModelComparator<T>
    implements Comparator<GridRowModel<T>> {
        private final IColumnDefinition<T> sortField;

        private GridRowModelComparator(IColumnDefinition<T> sortField) {
            this.sortField = sortField;
        }

        @Override
        public int compare(GridRowModel<T> o1, GridRowModel<T> o2) {
            Comparable<?> v1 = this.sortField.tryGetComparableValue(o1);
            Comparable<?> v2 = this.sortField.tryGetComparableValue(o2);
            if (v1 == null) {
                if (v2 == null) {
                    String s1 = this.sortField.getValue(o1);
                    String s2 = this.sortField.getValue(o2);
                    if (s1 == null) {
                        return -1;
                    }
                    if (s2 == null) {
                        return -1;
                    }
                    return s1.compareTo(s2);
                }
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return this.compare(v1, v2);
        }

        @Override
        protected int compare(Comparable v1, Comparable v2) {
            return v1.compareTo(v2);
        }

        /* synthetic */ GridRowModelComparator(IColumnDefinition iColumnDefinition, GridRowModelComparator gridRowModelComparator, GridRowModelComparator gridRowModelComparator2) {
            this(iColumnDefinition);
        }
    }
}

