/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class DeletionsProvider
extends AbstractCommonTableModelProvider<Deletion> {
    private static final int MAX_NUMBER = 5;

    public DeletionsProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<Deletion> createTableModel() {
        List<Deletion> deletions = this.commonServer.listOriginalDeletions(this.sessionToken);
        TypedTableModelBuilder<Deletion> builder = new TypedTableModelBuilder<Deletion>();
        builder.addColumn("DELETION_DATE").withDefaultWidth(300);
        builder.addColumn("DELETER").withDefaultWidth(200);
        builder.addColumn("ENTITIES").withDefaultWidth(300);
        builder.addColumn("REASON").withDefaultWidth(500);
        for (Deletion deletion : deletions) {
            builder.addRow(deletion);
            builder.column("DELETION_DATE").addDate(deletion.getRegistrationDate());
            builder.column("DELETER").addPerson(deletion.getRegistrator());
            builder.column("REASON").addString(deletion.getReason());
            if (deletion.getDeletedEntities().isEmpty()) continue;
            builder.column("ENTITIES").addString(this.createDescriptionOfDeletedEntities(deletion));
        }
        return builder.getModel();
    }

    private String createDescriptionOfDeletedEntities(Deletion deletion) {
        String dataSets;
        String samples;
        StringBuilder builder = new StringBuilder();
        String experiments = this.createList(deletion, EntityKind.EXPERIMENT, "Experiment");
        if (experiments.length() > 0) {
            builder.append(experiments);
        }
        if ((samples = this.createList(deletion, EntityKind.SAMPLE, "Sample")).length() > 0) {
            builder.append(samples);
        }
        if ((dataSets = this.createList(deletion, EntityKind.DATA_SET, "Data Set")).length() > 0) {
            builder.append(dataSets);
        }
        return builder.toString();
    }

    private String createList(Deletion deletion, EntityKind entityKind, String name) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (IEntityInformationHolderWithIdentifier entity : deletion.getDeletedEntities()) {
            if (entity.getEntityKind() != entityKind || count >= 5) continue;
            builder.append("  ").append(entity.getIdentifier()).append(" (");
            builder.append(entity.getEntityType().getCode()).append(")\n");
            ++count;
        }
        int numberOfAdditionalEntities = 0;
        switch (entityKind) {
            case DATA_SET: {
                numberOfAdditionalEntities = deletion.getTotalDatasetsCount();
                break;
            }
            case SAMPLE: {
                numberOfAdditionalEntities = deletion.getTotalSamplesCount();
                break;
            }
            case EXPERIMENT: {
                numberOfAdditionalEntities = deletion.getTotalExperimentsCount();
                break;
            }
        }
        numberOfAdditionalEntities -= count;
        if (count == 0) {
            if (numberOfAdditionalEntities == 0) {
                return "";
            }
            if (numberOfAdditionalEntities == 1) {
                return "1 " + name + "\n";
            }
            if (numberOfAdditionalEntities > 1) {
                return String.valueOf(numberOfAdditionalEntities) + " " + name + "s\n";
            }
        }
        if (numberOfAdditionalEntities > 0) {
            builder.append("  and ").append(numberOfAdditionalEntities).append(" more\n");
        }
        if (count == 1) {
            return String.valueOf(name) + " " + builder.toString();
        }
        return String.valueOf(name) + "s:\n" + builder.toString();
    }
}

