/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public abstract class EntityTypeProvider<T extends EntityType>
extends AbstractCommonTableModelProvider<T> {
    public EntityTypeProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<T> createTableModel() {
        List<T> types = this.listTypes();
        TypedTableModelBuilder<EntityType> builder = new TypedTableModelBuilder<EntityType>();
        builder.addColumn("CODE");
        builder.addColumn("DESCRIPTION").withDefaultWidth(300);
        builder.addColumn("DATABASE_INSTANCE").hideByDefault();
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("VALIDATION_SCRIPT").hideByDefault();
        this.addMoreColumns(builder);
        for (EntityType type : types) {
            builder.addRow(type);
            builder.column("CODE").addString(type.getCode());
            builder.column("DESCRIPTION").addString(type.getDescription());
            builder.column("DATABASE_INSTANCE").addString(type.getDatabaseInstance().getCode());
            builder.column("MODIFICATION_DATE").addDate(type.getModificationDate());
            builder.column("VALIDATION_SCRIPT").addString(type.getValidationScript() != null ? type.getValidationScript().getName() : "");
            this.addMoreCells(builder, type);
        }
        return builder.getModel();
    }

    protected abstract List<T> listTypes();

    protected void addMoreColumns(TypedTableModelBuilder<T> builder) {
    }

    protected void addMoreCells(TypedTableModelBuilder<T> builder, T type) {
    }
}

