/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ITableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class MatchingEntitiesProvider
implements ITableModelProvider<MatchingEntity> {
    private final ICommonServer commonServer;
    private final String sessionToken;
    private final SearchableEntity[] matchingEntities;
    private final String queryText;
    private final boolean useWildcardSearchMode;

    public MatchingEntitiesProvider(ICommonServer commonServer, String sessionToken, SearchableEntity[] matchingEntities, String queryText, boolean useWildcardSearchMode) {
        this.commonServer = commonServer;
        this.sessionToken = sessionToken;
        this.matchingEntities = matchingEntities;
        this.queryText = queryText;
        this.useWildcardSearchMode = useWildcardSearchMode;
    }

    @Override
    public TypedTableModel<MatchingEntity> getTableModel(int maxSize) {
        List<MatchingEntity> entities = this.commonServer.listMatchingEntities(this.sessionToken, this.matchingEntities, this.queryText, this.useWildcardSearchMode, maxSize);
        TypedTableModelBuilder<MatchingEntity> builder = new TypedTableModelBuilder<MatchingEntity>();
        builder.addColumn("ENTITY_KIND");
        builder.addColumn("ENTITY_TYPE");
        builder.addColumn("IDENTIFIER").withDefaultWidth(140);
        builder.addColumn("REGISTRATOR");
        builder.addColumn("MATCHING_FIELD").withDefaultWidth(140);
        builder.addColumn("MATCHING_TEXT").withDefaultWidth(200);
        for (MatchingEntity matchingEntity : entities) {
            builder.addRow(matchingEntity);
            builder.column("ENTITY_KIND").addString(matchingEntity.getEntityKind().getDescription());
            builder.column("ENTITY_TYPE").addString(matchingEntity.getEntityType().getCode());
            builder.column("IDENTIFIER").addString(matchingEntity.getIdentifier());
            builder.column("REGISTRATOR").addPerson(matchingEntity.getRegistrator());
            builder.column("MATCHING_FIELD").addString(matchingEntity.getFieldDescription());
            builder.column("MATCHING_TEXT").addString(matchingEntity.getTextFragment());
        }
        return builder.getModel();
    }
}

