/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListMetaprojectsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.HashSet;
import java.util.List;

public class MetaprojectProvider
extends AbstractCommonTableModelProvider<Metaproject> {
    private ListMetaprojectsCriteria criteria;

    public MetaprojectProvider(ICommonServer commonServer, String sessionToken, ListMetaprojectsCriteria criteria) {
        super(commonServer, sessionToken);
        this.criteria = criteria;
    }

    @Override
    protected TypedTableModel<Metaproject> createTableModel() {
        List<Metaproject> metaprojects = this.commonServer.listMetaprojects(this.sessionToken);
        TypedTableModelBuilder<Metaproject> builder = new TypedTableModelBuilder<Metaproject>();
        builder.addColumn("NAME");
        builder.addColumn("DESCRIPTION");
        builder.addColumn("CREATION_DATE").withDefaultWidth(300);
        HashSet<String> whitelistLowerCase = new HashSet<String>();
        if (this.criteria.getWhitelist() != null) {
            for (String whitelistItem : this.criteria.getWhitelist()) {
                whitelistLowerCase.add(whitelistItem.toLowerCase());
            }
            for (Metaproject metaproject : metaprojects) {
                if (!whitelistLowerCase.contains(metaproject.getName().toLowerCase())) continue;
                builder.addRow(metaproject);
                builder.column("NAME").addString(metaproject.getName());
                builder.column("DESCRIPTION").addString(metaproject.getDescription());
                builder.column("CREATION_DATE").addDate(metaproject.getCreationDate());
            }
            return builder.getModel();
        }
        HashSet<String> blacklistLowerCase = new HashSet<String>();
        if (this.criteria.getBlacklist() != null) {
            for (String blacklistItem : this.criteria.getBlacklist()) {
                blacklistLowerCase.add(blacklistItem.toLowerCase());
            }
        }
        for (Metaproject metaproject : metaprojects) {
            if (blacklistLowerCase.contains(metaproject.getName().toLowerCase())) continue;
            builder.addRow(metaproject);
            builder.column("NAME").addString(metaproject.getName());
            builder.column("DESCRIPTION").addString(metaproject.getDescription());
            builder.column("CREATION_DATE").addDate(metaproject.getCreationDate());
        }
        return builder.getModel();
    }
}

