/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.util;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GenericEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.util.XmlUtils;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

public class XMLPropertyTransformer {
    public <T> void transformXMLProperties(List<T> rows) {
        for (T row : rows) {
            if (!(row instanceof IEntityPropertiesHolder)) continue;
            IEntityPropertiesHolder propertiesHolder = (IEntityPropertiesHolder)row;
            List<IEntityProperty> properties = propertiesHolder.getProperties();
            for (IEntityProperty property : properties) {
                String transformation;
                GenericEntityProperty entityProperty;
                PropertyType propertyType;
                if (!(property instanceof GenericEntityProperty) || !(propertyType = (entityProperty = (GenericEntityProperty)property).getPropertyType()).getDataType().getCode().equals(DataTypeCode.XML) || (transformation = propertyType.getTransformation()) == null) continue;
                String xslt = StringEscapeUtils.unescapeHtml((String)transformation);
                String xmlString = StringEscapeUtils.unescapeHtml((String)entityProperty.getValue());
                String renderedXMLString = XmlUtils.transform(xslt, xmlString);
                entityProperty.setValue(renderedXMLString);
                entityProperty.setOriginalValue(xmlString);
            }
        }
    }
}

