/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.generic.shared.util.HttpRequestUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheFilter
implements Filter {
    private static final int HOUR_IN_SECONDS = 3600;
    private static final int DAY_IN_SECONDS = 86400;
    private static final int SPRINT_IN_SECONDS = 1209600;
    private static final String NO_CACHE = ".nocache.";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestURI = httpRequest.getRequestURI();
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (requestURI.contains(NO_CACHE)) {
            HttpRequestUtils.setNoCacheHeaders(httpResponse);
        } else {
            httpResponse.addHeader("Cache-Control", "max-age=" + (this.isPictureOrCache(requestURI) ? 1209600 : 3600));
        }
        filterChain.doFilter(request, response);
    }

    private boolean isPictureOrCache(String requestURI) {
        return requestURI.contains(".cache.") || requestURI.endsWith(".gif") || requestURI.endsWith(".png") || requestURI.endsWith(".ico");
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

