/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.IDataStoreServiceRegistrator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataSetTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatastoreServiceDescriptions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataStoreServiceRegistrator
implements IDataStoreServiceRegistrator {
    private static Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DataStoreServiceRegistrator.class);
    private final IDAOFactory daoFactory;
    private final Map<String, Map<DataStoreServiceKind, Map<String, DatastoreServiceDescription>>> dataStoreToServicesMap = new HashMap<String, Map<DataStoreServiceKind, Map<String, DatastoreServiceDescription>>>();

    public DataStoreServiceRegistrator(IDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public void setServiceDescriptions(DataStorePE dataStore, DatastoreServiceDescriptions serviceDescriptions) {
        Set<DataStoreServicePE> dataStoreServices = this.createDataStoreServices(serviceDescriptions);
        dataStore.setServices(dataStoreServices);
        this.daoFactory.getDataStoreDAO().createOrUpdateDataStore(dataStore);
        HashMap<DataStoreServiceKind, Map<String, DatastoreServiceDescription>> serviceKindToServicesMap = new HashMap<DataStoreServiceKind, Map<String, DatastoreServiceDescription>>();
        serviceKindToServicesMap.put(DataStoreServiceKind.QUERIES, this.extractMap(serviceDescriptions.getReportingServiceDescriptions()));
        serviceKindToServicesMap.put(DataStoreServiceKind.PROCESSING, this.extractMap(serviceDescriptions.getProcessingServiceDescriptions()));
        this.dataStoreToServicesMap.put(dataStore.getCode(), serviceKindToServicesMap);
    }

    private Map<String, DatastoreServiceDescription> extractMap(List<DatastoreServiceDescription> descriptions) {
        HashMap<String, DatastoreServiceDescription> map = new HashMap<String, DatastoreServiceDescription>();
        for (DatastoreServiceDescription description : descriptions) {
            map.put(description.getKey(), description);
        }
        return map;
    }

    private Set<DataStoreServicePE> createDataStoreServices(DatastoreServiceDescriptions serviceDescriptions) {
        HashSet<DataStoreServicePE> services = new HashSet<DataStoreServicePE>();
        IDataSetTypeDAO dataSetTypeDAO = this.daoFactory.getDataSetTypeDAO();
        List<DataSetTypePE> allDataSetTypes = dataSetTypeDAO.listAllEntities();
        Set<DataStoreServicePE> processing = this.createDataStoreServices(serviceDescriptions.getProcessingServiceDescriptions(), DataStoreServiceKind.PROCESSING, allDataSetTypes);
        services.addAll(processing);
        Set<DataStoreServicePE> queries = this.createDataStoreServices(serviceDescriptions.getReportingServiceDescriptions(), DataStoreServiceKind.QUERIES, allDataSetTypes);
        services.addAll(queries);
        return services;
    }

    private Set<DataStoreServicePE> createDataStoreServices(List<DatastoreServiceDescription> serviceDescriptions, DataStoreServiceKind serviceKind, List<DataSetTypePE> allDataSetTypes) {
        HashSet<DataStoreServicePE> services = new HashSet<DataStoreServicePE>();
        for (DatastoreServiceDescription desc : serviceDescriptions) {
            DataStoreServicePE service = new DataStoreServicePE();
            service.setKey(desc.getKey());
            service.setLabel(desc.getLabel());
            service.setKind(serviceKind);
            Set<DataSetTypePE> datasetTypes = this.extractDataSetTypes(desc.getDatasetTypeCodes(), desc, allDataSetTypes);
            service.setDatasetTypes(datasetTypes);
            service.setReportingPluginTypeOrNull(desc.tryReportingPluginType());
            services.add(service);
        }
        return services;
    }

    private Set<DataSetTypePE> extractDataSetTypes(String[] dataSetTypeCodePatterns, DatastoreServiceDescription serviceDescription, List<DataSetTypePE> allDataSetTypes) {
        HashSet<DataSetTypePE> dataSetTypes = new HashSet<DataSetTypePE>();
        HashSet<String> missingCodes = new HashSet<String>();
        String[] stringArray = dataSetTypeCodePatterns;
        int n = dataSetTypeCodePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            boolean found = false;
            for (DataSetTypePE dataSetType : allDataSetTypes) {
                if (!dataSetType.getCode().matches(pattern)) continue;
                dataSetTypes.add(dataSetType);
                found = true;
            }
            if (!found) {
                missingCodes.add(pattern);
            }
            ++n2;
        }
        if (missingCodes.size() > 0) {
            this.notifyDataStoreServerMisconfiguration(missingCodes, serviceDescription);
        }
        return dataSetTypes;
    }

    private void notifyDataStoreServerMisconfiguration(Set<String> missingCodes, DatastoreServiceDescription serviceDescription) {
        String missingCodesText = CollectionUtils.abbreviate(missingCodes, -1);
        notificationLog.warn((Object)String.format("The Datastore Server Plugin '%s' is misconfigured. It refers to the dataset types which do not exist in openBIS: %s", serviceDescription.toString(), missingCodesText));
    }

    @Override
    public void register(DataSetType dataSetType) {
        IDataStoreDAO dataStoreDAO = this.daoFactory.getDataStoreDAO();
        Set<Map.Entry<String, Map<DataStoreServiceKind, Map<String, DatastoreServiceDescription>>>> entrySet = this.dataStoreToServicesMap.entrySet();
        for (Map.Entry<String, Map<DataStoreServiceKind, Map<String, DatastoreServiceDescription>>> entry : entrySet) {
            String dataStoreCode = entry.getKey();
            Map<DataStoreServiceKind, Map<String, DatastoreServiceDescription>> serviceKindToServicesMap = entry.getValue();
            DataStorePE dataStore = dataStoreDAO.tryToFindDataStoreByCode(dataStoreCode);
            Set<DataStoreServicePE> services = dataStore.getServices();
            for (DataStoreServicePE service : services) {
                DataSetTypePE newDataSetType;
                DatastoreServiceDescription description;
                Set<DataSetTypePE> dataSetTypes = service.getDatasetTypes();
                if (this.containsDataType(dataSetTypes, dataSetType) || (description = serviceKindToServicesMap.get(service.getKind()).get(service.getKey())) == null || !this.matchesPattern(description, dataSetType) || (newDataSetType = this.daoFactory.getDataSetTypeDAO().tryToFindDataSetTypeByCode(dataSetType.getCode())) == null) continue;
                HashSet<DataSetTypePE> extendedDataSetTypes = new HashSet<DataSetTypePE>(dataSetTypes);
                extendedDataSetTypes.add(newDataSetType);
                service.setDatasetTypes(extendedDataSetTypes);
            }
            dataStoreDAO.createOrUpdateDataStore(dataStore);
        }
    }

    private boolean matchesPattern(DatastoreServiceDescription description, DataSetType dataSetType) {
        String[] datasetTypeCodePatterns;
        String[] stringArray = datasetTypeCodePatterns = description.getDatasetTypeCodes();
        int n = datasetTypeCodePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (dataSetType.getCode().matches(pattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean containsDataType(Collection<DataSetTypePE> dataSetTypes, DataSetType dataSetType) {
        for (DataSetTypePE dataSetTypePE : dataSetTypes) {
            if (!dataSetTypePE.getCode().equals(dataSetType.getCode())) continue;
            return true;
        }
        return false;
    }
}

