/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.util.MethodInvocationUtils;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LastModificationState;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;

public final class DatabaseLastModificationAdvisor
extends DefaultPointcutAdvisor {
    private static final long serialVersionUID = 1L;
    private static final Logger modificationLog = LogFactory.getLogger(LogCategory.OPERATION, DatabaseLastModificationAdvisor.class);

    public DatabaseLastModificationAdvisor(LastModificationState state) {
        super(DatabaseLastModificationAdvisor.createPointcut(), DatabaseLastModificationAdvisor.createAdvice(state));
    }

    private static final Advice createAdvice(LastModificationState state) {
        return new DatabaseLastModificationMethodInterceptor(state);
    }

    private static final Pointcut createPointcut() {
        AnnotationMatchingPointcut p1 = new AnnotationMatchingPointcut(null, DatabaseUpdateModification.class);
        AnnotationMatchingPointcut p2 = new AnnotationMatchingPointcut(null, DatabaseCreateOrDeleteModification.class);
        return new ComposablePointcut((Pointcut)p1).union((Pointcut)p2);
    }

    private static Set<DatabaseModificationKind> getModificationKinds(Method method) {
        HashSet<DatabaseModificationKind> categories = new HashSet<DatabaseModificationKind>();
        DatabaseLastModificationAdvisor.processCreateOrDeleteAnnotation(method, categories);
        DatabaseLastModificationAdvisor.processUpdateAnnotation(method, categories);
        return categories;
    }

    private static void processUpdateAnnotation(Method method, Set<DatabaseModificationKind> categories) {
        DatabaseUpdateModification annotation = method.getAnnotation(DatabaseUpdateModification.class);
        if (annotation == null) {
            return;
        }
        DatabaseModificationKind.ObjectKind[] objectKindArray = annotation.value();
        int n = objectKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseModificationKind.ObjectKind objectKind = objectKindArray[n2];
            categories.add(DatabaseModificationKind.edit(objectKind));
            ++n2;
        }
    }

    private static void processCreateOrDeleteAnnotation(Method method, Set<DatabaseModificationKind> categories) {
        DatabaseCreateOrDeleteModification annotation = method.getAnnotation(DatabaseCreateOrDeleteModification.class);
        if (annotation == null) {
            return;
        }
        DatabaseModificationKind.ObjectKind[] objectKindArray = annotation.value();
        int n = objectKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseModificationKind.ObjectKind objectKind = objectKindArray[n2];
            categories.add(DatabaseModificationKind.createOrDelete(objectKind));
            ++n2;
        }
    }

    private static final class DatabaseLastModificationMethodInterceptor
    implements MethodInterceptor {
        private static final List<Class<? extends Annotation>> HANDLED_ANNOTATIONS = Arrays.asList(DatabaseUpdateModification.class, DatabaseCreateOrDeleteModification.class);
        private final LastModificationState state;
        private final Map<Method, Set<DatabaseModificationKind>> annotationsCache = new HashMap<Method, Set<DatabaseModificationKind>>();

        public DatabaseLastModificationMethodInterceptor(LastModificationState state) {
            this.state = state;
        }

        public final Object invoke(MethodInvocation methodInvocation) throws Throwable {
            long currentTimestamp = new Date().getTime();
            Object result = methodInvocation.proceed();
            this.registerModification(MethodInvocationUtils.getMethod(methodInvocation, HANDLED_ANNOTATIONS), currentTimestamp);
            return result;
        }

        private void registerModification(Method method, long currentTimestamp) {
            Set<DatabaseModificationKind> modificationKinds = this.getCachedModificationKinds(method);
            for (DatabaseModificationKind modification : modificationKinds) {
                modificationLog.debug((Object)String.format("Method '%s' registered at %s: %s", MethodUtils.describeMethod(method), new Date(currentTimestamp), modification));
                this.state.registerModification(modification, currentTimestamp);
            }
        }

        private Set<DatabaseModificationKind> getCachedModificationKinds(Method method) {
            Set result = this.annotationsCache.get(method);
            if (result == null) {
                result = DatabaseLastModificationAdvisor.getModificationKinds(method);
                this.annotationsCache.put(method, result);
            }
            return result;
        }
    }
}

