/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.collection.GroupingDAG;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class EntityGroupingDAG<T> {
    private Collection<T> items;
    private HashMap<String, T> identifierMap;
    private HashMap<String, Collection<String>> adjacencyGraph;
    private List<List<T>> resultGroups;

    public EntityGroupingDAG(Collection<T> items) {
        this.items = items;
    }

    public List<List<T>> getDependencyGroups() {
        if (this.resultGroups == null) {
            this.buildGraph();
            this.calculateResults();
        }
        return this.resultGroups;
    }

    protected abstract String getCode(T var1);

    protected abstract Collection<String> getDependent(T var1);

    protected abstract Collection<String> getDependencies(T var1);

    private void buildGraph() {
        String code;
        this.identifierMap = new HashMap();
        this.adjacencyGraph = new HashMap();
        for (T item : this.items) {
            code = this.getCode(item);
            this.identifierMap.put(code, item);
            this.adjacencyGraph.put(code, new LinkedList());
        }
        for (T item : this.items) {
            Collection<String> dependencies;
            code = this.getCode(item);
            Collection<String> dependent = this.getDependent(item);
            if (dependent != null) {
                for (String depCode : dependent) {
                    if (!this.identifierMap.containsKey(depCode)) continue;
                    this.adjacencyGraph.get(code).add(depCode);
                }
            }
            if ((dependencies = this.getDependencies(item)) == null) continue;
            for (String depCode : dependencies) {
                if (!this.identifierMap.containsKey(depCode)) continue;
                this.adjacencyGraph.get(depCode).add(code);
            }
        }
    }

    private void calculateResults() {
        List<List<String>> identifierGroups = GroupingDAG.groupByDepencies(this.adjacencyGraph);
        this.resultGroups = new LinkedList<List<T>>();
        for (List<String> listOfIdentifiers : identifierGroups) {
            LinkedList<T> listOfItems = new LinkedList<T>();
            for (String identifier : listOfIdentifiers) {
                listOfItems.add(this.identifierMap.get(identifier));
            }
            this.resultGroups.add(listOfItems);
        }
    }
}

