/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetUpdatesCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewExperimentPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewExternalDataPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewProjectPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewSamplePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleUpdatesCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSpace;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.List;
import java.util.Map;

public interface IETLEntityOperationChecker {
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN, RoleWithHierarchy.INSTANCE_ETL_SERVER})
    @Capability(value="CREATE_SPACES_VIA_DSS")
    public void assertSpaceCreationAllowed(IAuthSession var1, List<NewSpace> var2);

    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ETL_SERVER})
    public void assertMaterialCreationAllowed(IAuthSession var1, Map<String, List<NewMaterial>> var2);

    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ETL_SERVER})
    public void assertMaterialUpdateAllowed(IAuthSession var1, List<MaterialUpdateDTO> var2);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="CREATE_PROJECTS_VIA_DSS")
    public void assertProjectCreationAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=NewProjectPredicate.class) List<NewProject> var2);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UPDATE_PROJECTS_VIA_DSS")
    public void assertProjectUpdateAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=ProjectUpdatesPredicate.class) List<ProjectUpdatesDTO> var2);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="CREATE_EXPERIMENTS_VIA_DSS")
    public void assertExperimentCreationAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=NewExperimentPredicate.class) List<NewExperiment> var2);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UPDATE_EXPERIMENTS_VIA_DSS")
    public void assertExperimentUpdateAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=ExperimentUpdatesPredicate.class) ExperimentUpdatesDTO var2);

    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ETL_SERVER})
    public void assertInstanceSampleCreationAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=NewSamplePredicate.class) List<NewSample> var2);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="CREATE_SPACE_SAMPLES_VIA_DSS")
    public void assertSpaceSampleCreationAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=NewSamplePredicate.class) List<NewSample> var2);

    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ETL_SERVER})
    public void assertInstanceSampleUpdateAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=SampleUpdatesCollectionPredicate.class) List<SampleUpdatesDTO> var2);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UPDATE_SPACE_SAMPLES_VIA_DSS")
    public void assertSpaceSampleUpdateAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=SampleUpdatesCollectionPredicate.class) List<SampleUpdatesDTO> var2);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="CREATE_DATA_SETS_VIA_DSS")
    public void assertDataSetCreationAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=NewExternalDataPredicate.class) List<? extends NewExternalData> var2);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UPDATE_DATA_SETS_VIA_DSS")
    public void assertDataSetUpdateAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=DataSetUpdatesCollectionPredicate.class) List<DataSetBatchUpdatesDTO> var2);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN, RoleWithHierarchy.INSTANCE_ETL_SERVER})
    @Capability(value="ASSIGN_ROLE_TO_SPACE_VIA_DSS")
    public void assertSpaceRoleAssignmentAllowed(IAuthSession var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier var2);
}

