/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationServiceUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

public class MetaprojectAssignmentsHelper {
    private final IDAOFactory daoFactory;
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public MetaprojectAssignmentsHelper(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.daoFactory = daoFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    public MetaprojectAssignments getMetaprojectAssignments(Session session, Metaproject metaproject, String userId, EnumSet<MetaprojectAssignmentsFetchOption> fetchOptions) {
        if (fetchOptions == null) {
            throw new IllegalArgumentException("Fetch options cannot be null");
        }
        String baseIndexURL = session.getBaseIndexURL();
        AuthorizationServiceUtils authorizationUtils = new AuthorizationServiceUtils(this.daoFactory, userId);
        MetaprojectAssignments metaprojectAssignments = new MetaprojectAssignments();
        metaprojectAssignments.setMetaproject(metaproject);
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        ArrayList<Sample> samples = new ArrayList<Sample>();
        ArrayList<AbstractExternalData> dataSets = new ArrayList<AbstractExternalData>();
        ArrayList<Material> materials = new ArrayList<Material>();
        if (fetchOptions.contains(MetaprojectAssignmentsFetchOption.EXPERIMENTS)) {
            for (MetaprojectAssignmentPE metaprojectAssignmentPE : this.getMetaprojectAssignments(metaproject.getId(), EntityKind.EXPERIMENT)) {
                if (authorizationUtils.canAccessExperiment(metaprojectAssignmentPE.getExperiment())) {
                    experiments.add(ExperimentTranslator.translate(metaprojectAssignmentPE.getExperiment(), baseIndexURL, null, this.managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields.PROPERTIES));
                    continue;
                }
                experiments.add(ExperimentTranslator.translateWithoutRevealingData(metaprojectAssignmentPE.getExperiment(), null));
            }
        }
        if (fetchOptions.contains(MetaprojectAssignmentsFetchOption.SAMPLES)) {
            for (MetaprojectAssignmentPE metaprojectAssignmentPE : this.getMetaprojectAssignments(metaproject.getId(), EntityKind.SAMPLE)) {
                if (authorizationUtils.canAccessSample(metaprojectAssignmentPE.getSample())) {
                    samples.add(SampleTranslator.translate(metaprojectAssignmentPE.getSample(), baseIndexURL, null, this.managedPropertyEvaluatorFactory));
                    continue;
                }
                samples.add(SampleTranslator.translateWithoutRevealingData(metaprojectAssignmentPE.getSample()));
            }
        }
        if (fetchOptions.contains(MetaprojectAssignmentsFetchOption.DATA_SETS)) {
            for (MetaprojectAssignmentPE metaprojectAssignmentPE : this.getMetaprojectAssignments(metaproject.getId(), EntityKind.DATA_SET)) {
                if (authorizationUtils.canAccessDataSet(metaprojectAssignmentPE.getDataSet())) {
                    dataSets.add(DataSetTranslator.translate(metaprojectAssignmentPE.getDataSet(), baseIndexURL, null, this.managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]));
                    continue;
                }
                dataSets.add(DataSetTranslator.translateWithoutRevealingData(metaprojectAssignmentPE.getDataSet()));
            }
        }
        if (fetchOptions.contains(MetaprojectAssignmentsFetchOption.MATERIALS)) {
            for (MetaprojectAssignmentPE metaprojectAssignmentPE : this.getMetaprojectAssignments(metaproject.getId(), EntityKind.MATERIAL)) {
                materials.add(MaterialTranslator.translate(metaprojectAssignmentPE.getMaterial(), null, this.managedPropertyEvaluatorFactory));
            }
        }
        metaprojectAssignments.setExperiments(experiments);
        metaprojectAssignments.setSamples(samples);
        metaprojectAssignments.setDataSets(dataSets);
        metaprojectAssignments.setMaterials(materials);
        return metaprojectAssignments;
    }

    public Collection<MetaprojectAssignmentPE> getMetaprojectAssignments(Long metaprojectId, EntityKind entityKind) {
        return this.daoFactory.getMetaprojectDAO().listMetaprojectAssignments(metaprojectId, DtoConverters.convertEntityKind(entityKind));
    }
}

