/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.conversation.manager.BaseServiceConversationClientManager;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationClientManagerLocal;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.conversation.ServiceConversationApplicationServerClientId;
import ch.systemsx.cisd.openbis.generic.shared.conversation.ServiceConversationDataStoreUrl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceConversationClientManager
extends BaseServiceConversationClientManager
implements IServiceConversationClientManagerLocal {
    private static final int DEFAULT_TIMEOUT = 5;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ServiceConversationClientManager.class);
    private Map<String, Integer> dataStoreUrlToDataStoreTimeoutMap = new HashMap<String, Integer>();

    @Override
    public IDataStoreService getDataStoreService(String dataStoreUrl, String sessionToken) {
        String dataStoreServerUrl = new ServiceConversationDataStoreUrl(dataStoreUrl).getServerUrl();
        ServiceConversationApplicationServerClientId applicationServerClientId = new ServiceConversationApplicationServerClientId();
        Integer dataStoreTimeoutInMillis = this.dataStoreUrlToDataStoreTimeoutMap.get(dataStoreUrl);
        if (dataStoreTimeoutInMillis == null) {
            operationLog.warn((Object)("No timeout defined for URL '" + dataStoreUrl + "'. Using default value of " + 5 + " minutes."));
            dataStoreTimeoutInMillis = 300000;
        }
        return this.getService(dataStoreServerUrl, IDataStoreService.class, sessionToken, applicationServerClientId, dataStoreTimeoutInMillis);
    }

    @Override
    public void setDataStoreInformation(String dataStoreUrl, int dataStoreTimeoutInMinutes) {
        this.dataStoreUrlToDataStoreTimeoutMap.put(dataStoreUrl, dataStoreTimeoutInMinutes * 60 * 1000);
    }
}

