/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TrustedCrossOriginDomainsProvider {
    private static final String LIST_SEPARATOR = ",";
    private final List<String> trustedDomains;

    public TrustedCrossOriginDomainsProvider(String trustedPropertyValue) {
        this.trustedDomains = trustedPropertyValue.startsWith("$") ? Collections.emptyList() : this.parseTrustedPropertyList(trustedPropertyValue);
    }

    public List<String> getTrustedDomains() {
        return Collections.unmodifiableList(this.trustedDomains);
    }

    private List<String> parseTrustedPropertyList(String trustedPropertyValue) {
        String[] items = trustedPropertyValue.split(LIST_SEPARATOR);
        int i = 0;
        while (i < items.length) {
            items[i] = items[i].trim();
            ++i;
        }
        return Arrays.asList(items);
    }
}

