/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.generic.shared.IRemoteHostValidator;
import java.util.HashSet;
import java.util.Set;

public class WhiteListBasedRemoteHostValidator
implements IRemoteHostValidator {
    private final Set<String> allowedRemoteHosts = new HashSet<String>();

    public WhiteListBasedRemoteHostValidator(String commaSeparatedListOfAllowedRemoteHosts) {
        if (commaSeparatedListOfAllowedRemoteHosts != null) {
            String[] list;
            String[] stringArray = list = commaSeparatedListOfAllowedRemoteHosts.split(",");
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String remoteHost = stringArray[n2];
                this.allowedRemoteHosts.add(remoteHost.trim());
                ++n2;
            }
        }
    }

    public void removeRemoteHost(String remoteHost) {
        this.allowedRemoteHosts.remove(remoteHost);
    }

    public void addRemoteHost(String remoteHost) {
        this.allowedRemoteHosts.add(remoteHost);
    }

    @Override
    public boolean isValidRemoteHost(String remoteHost) {
        return this.allowedRemoteHosts.contains(remoteHost);
    }
}

