/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.api.v1;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelatedEntities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class SampleToDataSetRelatedEntitiesTranslator {
    private final HashMap<Long, SampleType> sampleTypesMap;
    private final List<Sample> samples;
    private final ArrayList<BasicEntityInformationHolder> entityInformationHolders;

    public SampleToDataSetRelatedEntitiesTranslator(List<SampleType> sampleTypes, List<Sample> samples) {
        this.sampleTypesMap = SampleToDataSetRelatedEntitiesTranslator.convertSampleTypesListToMap(sampleTypes);
        this.samples = samples;
        this.entityInformationHolders = new ArrayList(samples.size());
    }

    private static HashMap<Long, SampleType> convertSampleTypesListToMap(List<SampleType> sampleTypes) {
        HashMap<Long, SampleType> map = new HashMap<Long, SampleType>(sampleTypes.size());
        for (SampleType sampleType : sampleTypes) {
            map.put(sampleType.getId(), sampleType);
        }
        return map;
    }

    public DataSetRelatedEntities convertToDataSetRelatedEntities() {
        for (Sample sample : this.samples) {
            BasicEntityInformationHolder holderOrNull = this.tryConvertSampleToEntityInformationHolder(sample);
            if (holderOrNull == null) continue;
            this.entityInformationHolders.add(holderOrNull);
        }
        return new DataSetRelatedEntities(this.entityInformationHolders);
    }

    private BasicEntityInformationHolder tryConvertSampleToEntityInformationHolder(Sample sample) {
        EntityType entityType = this.sampleTypesMap.get(sample.getSampleTypeId());
        if (entityType == null) {
            return null;
        }
        BasicEntityInformationHolder holder = new BasicEntityInformationHolder(EntityKind.SAMPLE, entityType, sample.getCode(), sample.getId(), sample.getPermId());
        return holder;
    }
}

