/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.SpaceOwnerKind;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;
import java.util.Set;

@ShouldFlattenCollections(value=false)
public class AbstractTechIdCollectionPredicate
extends AbstractSpacePredicate<List<TechId>> {
    private final SpaceOwnerKind entityKind;

    private AbstractTechIdCollectionPredicate(SpaceOwnerKind entityKind) {
        this.entityKind = entityKind;
    }

    @Override
    public String getCandidateDescription() {
        return (Object)((Object)this.entityKind) + " technical id collection";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<TechId> techIds) {
        assert (this.initialized) : "Predicate has not been initialized";
        Set<SpacePE> entitySpaces = this.authorizationDataProvider.getDistinctSpacesByEntityIds(this.entityKind, techIds);
        for (SpacePE space : entitySpaces) {
            Status result = this.evaluateSpace(person, allowedRoles, space);
            if (result.isOK()) continue;
            return result;
        }
        return Status.OK;
    }

    /* synthetic */ AbstractTechIdCollectionPredicate(SpaceOwnerKind spaceOwnerKind, AbstractTechIdCollectionPredicate abstractTechIdCollectionPredicate) {
        this(spaceOwnerKind);
    }

    public static class DataSetTechIdCollectionPredicate
    extends AbstractTechIdCollectionPredicate {
        public DataSetTechIdCollectionPredicate() {
            super(SpaceOwnerKind.DATASET, null);
        }
    }

    public static class ExperimentTechIdCollectionPredicate
    extends AbstractTechIdCollectionPredicate {
        public ExperimentTechIdCollectionPredicate() {
            super(SpaceOwnerKind.EXPERIMENT, null);
        }
    }

    public static class ProjectTechIdCollectionPredicate
    extends AbstractTechIdCollectionPredicate {
        public ProjectTechIdCollectionPredicate() {
            super(SpaceOwnerKind.PROJECT, null);
        }
    }

    public static class SpaceTechIdCollectionPredicate
    extends AbstractTechIdCollectionPredicate {
        public SpaceTechIdCollectionPredicate() {
            super(SpaceOwnerKind.SPACE, null);
        }
    }
}

