/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;
import java.util.Set;

@ShouldFlattenCollections(value=false)
public class DataSetCodeCollectionPredicate
extends AbstractSpacePredicate<List<String>> {
    @Override
    public String getCandidateDescription() {
        return "data set code";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<String> dataSetCodes) {
        assert (this.initialized) : "Predicate has not been initialized";
        Set<DataSetAccessPE> accessData = this.authorizationDataProvider.getDatasetCollectionAccessData(dataSetCodes);
        for (DataSetAccessPE accessDatum : accessData) {
            String spaceCode;
            String dbInstanceCode;
            String dbInstanceUUID = accessDatum.getDatabaseInstanceUuid();
            Status result = this.evaluate(person, allowedRoles, dbInstanceUUID, dbInstanceCode = accessDatum.getDatabaseInstanceCode(), spaceCode = accessDatum.getSpaceCode());
            if (result == Status.OK) continue;
            return result;
        }
        return Status.OK;
    }
}

