/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class DataSetCodePredicate
extends AbstractSpacePredicate<String> {
    @Override
    public String getCandidateDescription() {
        return "data set code";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, String dataSetCode) {
        assert (this.initialized) : "Predicate has not been initialized";
        DataSetAccessPE accessData = this.authorizationDataProvider.tryGetDatasetAccessData(dataSetCode);
        if (accessData != null) {
            String dbInstanceUUID = accessData.getDatabaseInstanceUuid();
            String dbInstanceCode = accessData.getDatabaseInstanceCode();
            String spaceCode = accessData.getSpaceCode();
            return this.evaluate(person, allowedRoles, dbInstanceUUID, dbInstanceCode, spaceCode);
        }
        return Status.OK;
    }
}

