/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@ShouldFlattenCollections(value=false)
public class DeletionTechIdCollectionPredicate
extends AbstractSpacePredicate<List<TechId>> {
    private SampleOwnerIdentifierCollectionPredicate sampleOwnerIdentifierCollectionPredicate = new SampleOwnerIdentifierCollectionPredicate(true);

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.sampleOwnerIdentifierCollectionPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "deletion technical id";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<TechId> value) {
        Set<ExperimentAccessPE> experiments = this.authorizationDataProvider.getDeletedExperimentCollectionAccessData(value);
        for (ExperimentAccessPE accessDatum : experiments) {
            String spaceCode;
            Object dbInstanceCode;
            String dbInstanceUUID = accessDatum.getDatabaseInstanceUuid();
            Status result = this.evaluate(person, allowedRoles, dbInstanceUUID, (String)(dbInstanceCode = accessDatum.getDatabaseInstanceCode()), spaceCode = accessDatum.getSpaceCode());
            if (result == Status.OK) continue;
            return result;
        }
        Set<SampleAccessPE> samples = this.authorizationDataProvider.getDeletedSampleCollectionAccessData(value);
        ArrayList<SampleOwnerIdentifier> ownerIds = new ArrayList<SampleOwnerIdentifier>();
        for (SampleAccessPE accessDatum : samples) {
            String ownerCode = accessDatum.getOwnerCode();
            switch (accessDatum.getOwnerType()) {
                case SPACE: {
                    ownerIds.add(new SampleOwnerIdentifier(new SpaceIdentifier(DatabaseInstanceIdentifier.createHome(), ownerCode)));
                    break;
                }
                case DATABASE_INSTANCE: {
                    ownerIds.add(new SampleOwnerIdentifier(new DatabaseInstanceIdentifier(ownerCode)));
                }
            }
        }
        Status status = this.sampleOwnerIdentifierCollectionPredicate.evaluate(person, allowedRoles, ownerIds);
        if (status != Status.OK) {
            return status;
        }
        Set<DataSetAccessPE> datasets = this.authorizationDataProvider.getDeletedDatasetCollectionAccessData(value);
        for (DataSetAccessPE accessDatum : datasets) {
            String spaceCode;
            String dbInstanceCode;
            String dbInstanceUUID = accessDatum.getDatabaseInstanceUuid();
            Status result = this.evaluate(person, allowedRoles, dbInstanceUUID, dbInstanceCode = accessDatum.getDatabaseInstanceCode(), spaceCode = accessDatum.getSpaceCode());
            if (result == Status.OK) continue;
            return result;
        }
        return Status.OK;
    }
}

