/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSampleCriteriaPredicate
extends AbstractSpacePredicate<ListSampleCriteria> {
    private final AbstractTechIdPredicate.ExperimentTechIdPredicate experimentTechIdPredicate = new AbstractTechIdPredicate.ExperimentTechIdPredicate();
    private final SampleTechIdPredicate sampleTechIdPredicate = new SampleTechIdPredicate();
    private final SampleTechIdCollectionPredicate sampleTechIdCollectionPredicate = new SampleTechIdCollectionPredicate();
    private DatabaseInstancePE homeDatabase;

    public ListSampleCriteriaPredicate() {
        super(true);
    }

    @Override
    public String getCandidateDescription() {
        return "sample listing criteria";
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.homeDatabase = provider.getHomeDatabaseInstance();
        this.experimentTechIdPredicate.init(provider);
        this.sampleTechIdPredicate.init(provider);
        this.sampleTechIdCollectionPredicate.init(provider);
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ListSampleCriteria value) {
        Status status = Status.OK;
        if (value.getExperimentId() != null) {
            status = this.experimentTechIdPredicate.doEvaluation(person, allowedRoles, value.getExperimentId());
        } else if (value.getContainerSampleIds() != null) {
            status = this.sampleTechIdCollectionPredicate.doEvaluation(person, allowedRoles, ListSampleCriteriaPredicate.asTechIds(value.getContainerSampleIds()));
        } else if (value.getParentSampleId() != null) {
            status = this.sampleTechIdPredicate.doEvaluation(person, allowedRoles, value.getParentSampleId());
        } else if (value.getChildSampleId() != null) {
            status = this.sampleTechIdPredicate.doEvaluation(person, allowedRoles, value.getChildSampleId());
        }
        if (value.isIncludeSpace() && status == Status.OK) {
            status = this.evaluate(person, allowedRoles, this.homeDatabase, value.getSpaceCode());
        }
        return status;
    }

    private static List<TechId> asTechIds(Collection<Long> ids) {
        ArrayList<TechId> techIds = new ArrayList<TechId>();
        for (Long id : ids) {
            techIds.add(new TechId(id));
        }
        return techIds;
    }
}

