/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractProjectPredicate;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.IProjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.ProjectIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.ProjectPermIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.ProjectTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class ProjectIdPredicate
extends AbstractProjectPredicate<IProjectId> {
    @Override
    public String getCandidateDescription() {
        return "project id";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, IProjectId projectId) {
        assert (this.spacePredicate.initialized) : "Predicate has not been initialized";
        assert (this.projectTechIdPredicate.initialized) : "Predicate has not been initialized";
        assert (this.projectPermIdPredicate.initialized) : "Predicate has not been initialized";
        assert (this.projectAugmentedCodePredicate.initialized) : "Predicate has not been initialized";
        if (projectId instanceof ProjectIdentifierId) {
            ProjectIdentifierId identifierId = (ProjectIdentifierId)projectId;
            return this.projectAugmentedCodePredicate.doEvaluation(person, allowedRoles, identifierId.getIdentifier());
        }
        if (projectId instanceof ProjectPermIdId) {
            ProjectPermIdId permIdId = (ProjectPermIdId)projectId;
            return this.projectPermIdPredicate.doEvaluation(person, allowedRoles, permIdId.getPermId());
        }
        if (projectId instanceof ProjectTechIdId) {
            ProjectTechIdId techIdId = (ProjectTechIdId)projectId;
            return this.projectTechIdPredicate.doEvaluation(person, allowedRoles, new TechId(techIdId.getTechId()));
        }
        return Status.createError("Unsupported project id: " + projectId);
    }
}

