/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSamplePredicate;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.ISampleId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.SampleIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.SamplePermIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.SampleTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class SampleIdPredicate
extends AbstractSamplePredicate<ISampleId> {
    @Override
    public String getCandidateDescription() {
        return "sample id";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ISampleId sampleId) {
        assert (this.spacePredicate.initialized) : "Predicate has not been initialized";
        assert (this.sampleTechIdPredicate.initialized) : "Predicate has not been initialized";
        assert (this.samplePermIdPredicate.initialized) : "Predicate has not been initialized";
        assert (this.sampleAugmentedCodePredicate.initialized) : "Predicate has not been initialized";
        if (sampleId instanceof SampleIdentifierId) {
            SampleIdentifierId identifierId = (SampleIdentifierId)sampleId;
            return this.sampleAugmentedCodePredicate.doEvaluation(person, allowedRoles, identifierId.getIdentifier());
        }
        if (sampleId instanceof SamplePermIdId) {
            SamplePermIdId permIdId = (SamplePermIdId)sampleId;
            return this.samplePermIdPredicate.doEvaluation(person, allowedRoles, new PermId(permIdId.getPermId()));
        }
        if (sampleId instanceof SampleTechIdId) {
            SampleTechIdId techIdId = (SampleTechIdId)sampleId;
            return this.sampleTechIdPredicate.doEvaluation(person, allowedRoles, new TechId(techIdId.getTechId()));
        }
        return Status.createError("Unsupported sample id: " + sampleId);
    }
}

