/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.db.mapper.LongArrayMapper;
import ch.systemsx.cisd.common.db.mapper.StringArrayMapper;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;

@ShouldFlattenCollections(value=false)
public class SampleListPredicate
extends AbstractSpacePredicate<List<Sample>> {
    private static final int ARRAY_SIZE_LIMIT = 999;
    private final SampleOwnerIdentifierPredicate idOwnerPredicate = new SampleOwnerIdentifierPredicate();
    private final ISampleToSpaceQuery sampleToSpaceQuery = (ISampleToSpaceQuery)QueryTool.getManagedQuery(ISampleToSpaceQuery.class);

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.idOwnerPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "sample";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<Sample> samples) {
        Status status;
        ArrayList<Long> ids = new ArrayList<Long>(samples.size());
        ArrayList<String> permIds = new ArrayList<String>(samples.size());
        for (Sample sample : samples) {
            if (sample.getId() == null) {
                throw new AuthorizationFailureException("id is undefined.");
            }
            ids.add(sample.getId());
            if (sample.getPermId() == null) {
                throw new AuthorizationFailureException("permId is undefined.");
            }
            permIds.add(sample.getPermId());
            if (sample.getSpaceCode() != null && !Status.OK.equals(status = this.evaluate(person, allowedRoles, this.authorizationDataProvider.getHomeDatabaseInstance(), sample.getSpaceCode()))) {
                return status;
            }
            SampleIdentifier idOwner = SampleIdentifierFactory.parse(sample.getIdentifier());
            Status status2 = this.idOwnerPredicate.evaluate(person, allowedRoles, idOwner);
            if (Status.OK.equals(status2)) continue;
            return status2;
        }
        for (Long spaceId : this.getSampleSpaceIds(ids, permIds)) {
            if (spaceId == null || Status.OK.equals(status = this.evaluate(person, allowedRoles, spaceId))) continue;
            return status;
        }
        return Status.OK;
    }

    private Collection<Long> getSampleSpaceIds(List<Long> ids, List<String> permIds) {
        if (ids.size() != permIds.size()) {
            throw new IllegalArgumentException("Expect to get the same number of ids and permIds.");
        }
        int size = ids.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size > 999) {
            HashSet<Long> spaceIds = new HashSet<Long>(size);
            int startIdx = 0;
            while (startIdx < size) {
                List<Long> idSubList = ids.subList(startIdx, Math.min(size, startIdx + 999));
                List<String> permIdSubList = permIds.subList(startIdx, Math.min(size, startIdx + 999));
                spaceIds.addAll(this.sampleToSpaceQuery.getSampleSpaceIds(this.toArray(idSubList), permIdSubList.toArray(new String[permIdSubList.size()])));
                startIdx += 999;
            }
            return spaceIds;
        }
        return this.sampleToSpaceQuery.getSampleSpaceIds(this.toArray(ids), permIds.toArray(new String[size]));
    }

    private long[] toArray(List<Long> list) {
        long[] result = new long[list.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = list.get(i);
            ++i;
        }
        return result;
    }

    public static interface ISampleToSpaceQuery
    extends BaseQuery {
        @Select(sql="select distinct space_id from samples where id = any(?{1}) union select distinct space_id from samples where perm_id = any(?{2})", parameterBindings={LongArrayMapper.class, StringArrayMapper.class})
        public List<Long> getSampleSpaceIds(long[] var1, String[] var2);
    }
}

