/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DelegatedPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@ShouldFlattenCollections(value=false)
public class SampleTechIdCollectionPredicate
extends DelegatedPredicate<List<SampleOwnerIdentifier>, List<TechId>> {
    public SampleTechIdCollectionPredicate(boolean isReadAccess) {
        super(new SampleOwnerIdentifierCollectionPredicate(isReadAccess));
    }

    public SampleTechIdCollectionPredicate() {
        this(true);
    }

    @Override
    public List<SampleOwnerIdentifier> tryConvert(List<TechId> techIds) {
        ArrayList<SampleOwnerIdentifier> ownerIds = new ArrayList<SampleOwnerIdentifier>();
        Set<SampleAccessPE> accessData = this.authorizationDataProvider.getSampleCollectionAccessData(techIds);
        for (SampleAccessPE accessDatum : accessData) {
            String ownerCode = accessDatum.getOwnerCode();
            switch (accessDatum.getOwnerType()) {
                case SPACE: {
                    ownerIds.add(new SampleOwnerIdentifier(new SpaceIdentifier(DatabaseInstanceIdentifier.createHome(), ownerCode)));
                    break;
                }
                case DATABASE_INSTANCE: {
                    ownerIds.add(new SampleOwnerIdentifier(new DatabaseInstanceIdentifier(ownerCode)));
                }
            }
        }
        return ownerIds;
    }

    @Override
    public final String getCandidateDescription() {
        return "sample technical ids";
    }
}

