/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class DeletionValidator
extends AbstractValidator<Deletion> {
    @Override
    public final boolean doValidation(PersonPE person, Deletion value) {
        return this.isRegistrator(person, value) || DeletionValidator.isInstanceAdmin(person) || this.isSpaceAdmin(person, value);
    }

    private boolean isSpaceAdmin(PersonPE person, Deletion value) {
        List<TechId> singletonList = Collections.singletonList(new TechId(value.getId()));
        Set<ExperimentAccessPE> experimentAccessData = this.authorizationDataProvider.getDeletedExperimentCollectionAccessData(singletonList);
        for (ExperimentAccessPE experimentAccessDatum : experimentAccessData) {
            if (!this.verifySpace(person, experimentAccessDatum.getSpaceCode(), experimentAccessDatum.getDatabaseInstanceCode())) continue;
            return true;
        }
        Set<SampleAccessPE> sampleAccessData = this.authorizationDataProvider.getDeletedSampleCollectionAccessData(singletonList);
        for (SampleAccessPE sampleAccessDatum : sampleAccessData) {
            String ownerCode = sampleAccessDatum.getOwnerCode();
            switch (sampleAccessDatum.getOwnerType()) {
                case SPACE: {
                    SpaceIdentifier si = new SpaceIdentifier(DatabaseInstanceIdentifier.createHome(), ownerCode);
                    if (!this.verifySpace(person, si.getSpaceCode(), si.getDatabaseInstanceCode())) break;
                    return true;
                }
                case DATABASE_INSTANCE: {
                    if (!this.verifyDBInstance(person, ownerCode)) break;
                    return true;
                }
            }
        }
        Set<DataSetAccessPE> datasets = this.authorizationDataProvider.getDeletedDatasetCollectionAccessData(singletonList);
        for (DataSetAccessPE datasetAccessDatum : datasets) {
            if (!this.verifySpace(person, datasetAccessDatum.getSpaceCode(), datasetAccessDatum.getDatabaseInstanceCode())) continue;
            return true;
        }
        return false;
    }

    private final boolean verifyDBInstance(PersonPE person, String databaseInstanceCode) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            SpacePE space = roleAssignment.getSpace();
            if (space == null || !roleAssignment.getRole().equals(RoleWithHierarchy.RoleCode.ADMIN) || !space.getDatabaseInstance().getCode().equals(databaseInstanceCode)) continue;
            return true;
        }
        return false;
    }

    private boolean verifySpace(PersonPE person, String spaceCode, String dbInstanceCode) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            SpacePE space = roleAssignment.getSpace();
            if (space == null || !roleAssignment.getRole().equals(RoleWithHierarchy.RoleCode.ADMIN) || !space.getCode().equals(spaceCode) || !space.getDatabaseInstance().getCode().equals(dbInstanceCode)) continue;
            return true;
        }
        return false;
    }

    private boolean isRegistrator(PersonPE person, Deletion value) {
        Person registrator = value.getRegistrator();
        return person.getUserId().equals(registrator.getUserId()) && person.getDatabaseInstance().getCode().equals(registrator.getDatabaseInstance().getCode());
    }

    private static boolean isInstanceAdmin(PersonPE person) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            DatabaseInstancePE roleInstance = roleAssignment.getDatabaseInstance();
            if (roleInstance == null || !roleAssignment.getRole().equals(RoleWithHierarchy.RoleCode.ADMIN)) continue;
            return true;
        }
        return false;
    }
}

