/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.batch;

import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.batch.IProgressAware;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleTable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class SampleBatchRegistration
implements IBatchOperation<NewSample>,
IProgressAware {
    private final ISampleTable businessTable;
    private final List<NewSample> entities;
    private final PersonPE registratorOrNull;
    private int endIndex;
    private int maxIndex;
    private int limit;

    public SampleBatchRegistration(ISampleTable businessTable, List<NewSample> entities, PersonPE registratorOrNull) {
        this(businessTable, entities, registratorOrNull, 50000);
    }

    public SampleBatchRegistration(ISampleTable businessTable, List<NewSample> entities, PersonPE registratorOrNull, int limit) {
        this.businessTable = businessTable;
        this.entities = entities;
        this.registratorOrNull = registratorOrNull;
        this.limit = limit;
    }

    @Override
    public void execute(List<NewSample> batch) {
        this.businessTable.prepareForRegistration(batch, this.registratorOrNull);
        this.businessTable.save(this.maxIndex - this.endIndex > this.limit);
    }

    @Override
    public List<NewSample> getAllEntities() {
        return this.entities;
    }

    @Override
    public String getEntityName() {
        return "sample";
    }

    @Override
    public String getOperationName() {
        return "registration";
    }

    @Override
    public void setNextChunk(int startIndex, int endIndex, int maxIndex) {
        this.endIndex = endIndex;
        this.maxIndex = maxIndex;
    }
}

