/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.batch;

import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.batch.IProgressAware;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleTable;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleBatchUpdatesDTO;
import java.util.List;

public class SampleBatchUpdate
implements IBatchOperation<SampleBatchUpdatesDTO>,
IProgressAware {
    private final ISampleTable businessTable;
    private final List<SampleBatchUpdatesDTO> entities;
    private int endIndex;
    private int maxIndex;
    int limit;

    public SampleBatchUpdate(ISampleTable businessTable, List<SampleBatchUpdatesDTO> entities, int limit) {
        this.businessTable = businessTable;
        this.entities = entities;
        this.limit = limit;
    }

    @Override
    public void execute(List<SampleBatchUpdatesDTO> updates) {
        this.businessTable.prepareForUpdate(updates);
        this.businessTable.save(this.maxIndex - this.endIndex > this.limit);
    }

    @Override
    public List<SampleBatchUpdatesDTO> getAllEntities() {
        return this.entities;
    }

    @Override
    public String getEntityName() {
        return "sample";
    }

    @Override
    public String getOperationName() {
        return "update";
    }

    @Override
    public void setNextChunk(int startIndex, int endIndex, int maxIndex) {
        this.endIndex = endIndex;
        this.maxIndex = maxIndex;
    }
}

