/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDeletionTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.RootEntitiesFinder;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DeletionTranslator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeletionTable
extends AbstractBusinessObject
implements IDeletionTable {
    private List<Deletion> deletions;

    public DeletionTable(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
    }

    @Override
    public List<Deletion> getDeletions() {
        return this.deletions;
    }

    @Override
    public void load(boolean withEntities) {
        this.load(withEntities, false);
    }

    @Override
    public void loadOriginal() {
        this.load(true, true);
    }

    private void load(boolean withEntities, boolean onlyOriginal) {
        List<DeletionPE> deletionPEs = this.getDeletionDAO().listAllEntities();
        Collections.sort(deletionPEs);
        this.deletions = DeletionTranslator.translate(deletionPEs);
        if (!withEntities) {
            return;
        }
        HashMap<Long, RootEntitiesFinder> findersMap = new HashMap<Long, RootEntitiesFinder>();
        for (DeletionPE deletionPE : deletionPEs) {
            findersMap.put(deletionPE.getId(), new RootEntitiesFinder());
        }
        if (!this.deletions.isEmpty()) {
            this.findEntities(TrashEntity.EXPERIMENT, findersMap, onlyOriginal);
            this.findEntities(TrashEntity.SAMPLE, findersMap, onlyOriginal);
            this.findEntities(TrashEntity.DATA_SET, findersMap, onlyOriginal);
        }
        for (Deletion deletion : this.deletions) {
            ((RootEntitiesFinder)findersMap.get(deletion.getId())).addRootEntitiesTo(deletion);
        }
    }

    private void findEntities(TrashEntity kind, Map<Long, RootEntitiesFinder> findersMap, boolean onlyOriginal) {
        IDeletionDAO deletionDAO = this.getDeletionDAO();
        for (Deletion deletion : this.deletions) {
            List<TechId> deletedEntitiesIds = onlyOriginal ? kind.originalDeletedEntityIds(deletionDAO, Collections.singletonList(new TechId(deletion.getId()))) : kind.deletedEntityIds(deletionDAO, Collections.singletonList(new TechId(deletion.getId())));
            EntityKind entityKind = kind.entityKind;
            int count = deletedEntitiesIds.size();
            switch (entityKind) {
                case DATA_SET: {
                    deletion.setTotalDatasetsCount(count);
                    break;
                }
                case SAMPLE: {
                    deletion.setTotalSamplesCount(count);
                    break;
                }
                case EXPERIMENT: {
                    deletion.setTotalExperimentsCount(count);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported entity type " + (Object)((Object)entityKind));
                }
            }
            List<? extends IDeletablePE> entities = deletionDAO.listDeletedEntities(kind.entityKind, deletedEntitiesIds);
            this.addEntities(entities, findersMap);
        }
    }

    private void addEntities(List<? extends IDeletablePE> entities, Map<Long, RootEntitiesFinder> findersMap) {
        for (IDeletablePE iDeletablePE : entities) {
            RootEntitiesFinder finder;
            DeletionPE deletion = iDeletablePE.getDeletion();
            if (deletion == null || (finder = findersMap.get(deletion.getId())) == null) continue;
            finder.addEntity(iDeletablePE);
        }
    }

    private static enum TrashEntity {
        SAMPLE(EntityKind.SAMPLE){

            @Override
            List<TechId> deletedEntityIds(IDeletionDAO dao, List<TechId> deletionIDs) {
                return dao.findTrashedSampleIds(deletionIDs);
            }

            @Override
            List<TechId> originalDeletedEntityIds(IDeletionDAO dao, List<TechId> deletionIDs) {
                return dao.findOriginalTrashedSampleIds(deletionIDs);
            }
        }
        ,
        EXPERIMENT(EntityKind.EXPERIMENT){

            @Override
            List<TechId> deletedEntityIds(IDeletionDAO dao, List<TechId> deletionIDs) {
                return dao.findTrashedExperimentIds(deletionIDs);
            }

            @Override
            List<TechId> originalDeletedEntityIds(IDeletionDAO dao, List<TechId> deletionIDs) {
                return dao.findOriginalTrashedExperimentIds(deletionIDs);
            }
        }
        ,
        DATA_SET(EntityKind.DATA_SET){

            @Override
            List<TechId> deletedEntityIds(IDeletionDAO dao, List<TechId> deletionIDs) {
                return dao.findTrashedDataSetIds(deletionIDs);
            }

            @Override
            List<TechId> originalDeletedEntityIds(IDeletionDAO dao, List<TechId> deletionIDs) {
                return dao.findOriginalTrashedDataSetIds(deletionIDs);
            }
        };

        final EntityKind entityKind;

        private TrashEntity(EntityKind entityKind) {
            this.entityKind = entityKind;
        }

        abstract List<TechId> deletedEntityIds(IDeletionDAO var1, List<TechId> var2);

        abstract List<TechId> originalDeletedEntityIds(IDeletionDAO var1, List<TechId> var2);
    }
}

