/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IPropertyTypeTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.List;

public final class PropertyTypeTable
extends AbstractBusinessObject
implements IPropertyTypeTable {
    private List<PropertyTypePE> propertyTypes;

    public PropertyTypeTable(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
    }

    @Override
    public List<PropertyTypePE> getPropertyTypes() {
        if (this.propertyTypes == null) {
            throw new IllegalStateException("Unloaded property types.");
        }
        return this.propertyTypes;
    }

    @Override
    public void load() {
        this.propertyTypes = this.getPropertyTypeDAO().listAllPropertyTypes();
    }

    @Override
    public void loadWithRelations() {
        this.propertyTypes = this.getPropertyTypeDAO().listAllPropertyTypesWithRelations();
    }

    @Override
    public final void enrichWithRelations() {
        if (this.propertyTypes == null) {
            throw new IllegalStateException("Unloaded property types.");
        }
        for (PropertyTypePE pt : this.propertyTypes) {
            HibernateUtils.initialize(pt.getMaterialTypePropertyTypes());
            HibernateUtils.initialize(pt.getSampleTypePropertyTypes());
            HibernateUtils.initialize(pt.getExperimentTypePropertyTypes());
            HibernateUtils.initialize(pt.getDataSetTypePropertyTypes());
            HibernateUtils.initialize(pt.getVocabulary());
        }
    }
}

