/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IRoleAssignmentTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.util.KeyExtractorFactory;
import ch.systemsx.cisd.openbis.generic.server.util.SpaceIdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewRoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;

public final class RoleAssignmentTable
extends AbstractBusinessObject
implements IRoleAssignmentTable {
    private List<RoleAssignmentPE> roleAssignments;
    private TableMap<String, PersonPE> personsByUserId;
    private TableMap<String, AuthorizationGroupPE> authorizationGroupsByCode;

    public RoleAssignmentTable(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
    }

    private final PersonPE getPerson(String userId) {
        PersonPE person;
        if (this.personsByUserId == null) {
            this.personsByUserId = new TableMap<String, PersonPE>(this.getPersonDAO().listPersons(), KeyExtractorFactory.getPersonByUserIdKeyExtractor());
        }
        if ((person = this.personsByUserId.tryGet(userId)) == null) {
            throw UserFailureException.fromTemplate("No person could be found for user id '%s'", userId);
        }
        return person;
    }

    private final AuthorizationGroupPE getAuthorizationGroup(String authGroupId) {
        AuthorizationGroupPE authGroup;
        if (this.authorizationGroupsByCode == null) {
            this.authorizationGroupsByCode = new TableMap<String, AuthorizationGroupPE>(this.getAuthorizationGroupDAO().list(), KeyExtractorFactory.getAuthorizationGroupByCodeKeyExtractor());
        }
        if ((authGroup = this.authorizationGroupsByCode.tryGet(authGroupId)) == null) {
            throw UserFailureException.fromTemplate("No authorization group could be found for code '%s'", authGroupId);
        }
        return authGroup;
    }

    @Override
    public final void add(NewRoleAssignment newRoleAssignment) {
        if (this.roleAssignments == null) {
            this.roleAssignments = new ArrayList<RoleAssignmentPE>();
        }
        RoleAssignmentPE roleAssignment = new RoleAssignmentPE();
        DatabaseInstanceIdentifier databaseInstanceIdentifier = newRoleAssignment.getDatabaseInstanceIdentifier();
        if (databaseInstanceIdentifier != null) {
            DatabaseInstancePE databaseInstance = SpaceIdentifierHelper.getDatabaseInstance(databaseInstanceIdentifier, this);
            roleAssignment.setDatabaseInstance(databaseInstance);
        } else {
            SpaceIdentifier groupIdentifier = newRoleAssignment.getSpaceIdentifier();
            SpacePE group = SpaceIdentifierHelper.tryGetSpace(groupIdentifier, this.session.tryGetPerson(), this);
            if (group == null) {
                throw UserFailureException.fromTemplate("Specified space '%s' could not be found", groupIdentifier);
            }
            roleAssignment.setSpace(group);
        }
        roleAssignment.setRegistrator(this.findPerson());
        roleAssignment.setRole(newRoleAssignment.getRole());
        if (Grantee.GranteeType.PERSON.equals(newRoleAssignment.getGrantee().getType())) {
            this.getPerson(newRoleAssignment.getGrantee().getCode()).addRoleAssignment(roleAssignment);
        } else {
            this.getAuthorizationGroup(newRoleAssignment.getGrantee().getCode().toUpperCase()).addRoleAssignment(roleAssignment);
        }
        this.roleAssignments.add(roleAssignment);
    }

    @Override
    public final void save() throws UserFailureException {
        assert (this.roleAssignments != null) : "Role assignments unspecified";
        for (RoleAssignmentPE roleAssignment : this.roleAssignments) {
            try {
                this.getRoleAssignmentDAO().createRoleAssignment(roleAssignment);
            }
            catch (DataIntegrityViolationException ex) {
                RoleAssignmentTable.throwException((DataAccessException)((Object)ex), "Role assignment");
            }
        }
    }
}

