/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.common;

import ch.systemsx.cisd.openbis.generic.server.business.bo.common.AbstractBatchIterator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.CodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesEnricher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesHolderResolver;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertySetListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IPropertyListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.MaterialEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.VocabularyTermRecord;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GenericEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermEntityProperty;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;

public final class EntityPropertiesEnricher
implements IEntityPropertiesEnricher {
    private final IPropertyListingQuery query;
    private final IEntityPropertySetListingQuery propertySetQuery;

    public EntityPropertiesEnricher(IPropertyListingQuery query, IEntityPropertySetListingQuery setQuery) {
        this.query = query;
        this.propertySetQuery = this.createEfficientIterator(setQuery);
    }

    private IEntityPropertySetListingQuery createEfficientIterator(final IEntityPropertySetListingQuery setQuery) {
        return new IEntityPropertySetListingQuery(){
            private static final int BATCH_SIZE = 50000;

            @Override
            public Iterable<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet entityIDs) {
                return new AbstractBatchIterator<GenericEntityPropertyRecord>(entityIDs, 50000){

                    @Override
                    protected Iterable<GenericEntityPropertyRecord> createUnefficientIterator(LongSet ids) {
                        return setQuery.getEntityPropertyGenericValues(ids);
                    }
                };
            }

            @Override
            public Iterable<VocabularyTermRecord> getEntityPropertyVocabularyTermValues(LongSet entityIDs) {
                return new AbstractBatchIterator<VocabularyTermRecord>(entityIDs, 50000){

                    @Override
                    protected Iterable<VocabularyTermRecord> createUnefficientIterator(LongSet ids) {
                        return setQuery.getEntityPropertyVocabularyTermValues(ids);
                    }
                };
            }

            @Override
            public Iterable<MaterialEntityPropertyRecord> getEntityPropertyMaterialValues(LongSet entityIDs) {
                return new AbstractBatchIterator<MaterialEntityPropertyRecord>(entityIDs, 50000){

                    @Override
                    protected Iterable<MaterialEntityPropertyRecord> createUnefficientIterator(LongSet ids) {
                        return setQuery.getEntityPropertyMaterialValues(ids);
                    }
                };
            }
        };
    }

    @Override
    public void enrich(LongSet entityIDs, IEntityPropertiesHolderResolver entities) {
        Long2ObjectMap<PropertyType> propertyTypes = this.getPropertyTypes();
        for (GenericEntityPropertyRecord val : this.propertySetQuery.getEntityPropertyGenericValues(entityIDs)) {
            IEntityPropertiesHolder entity = entities.get(val.entity_id);
            GenericEntityProperty property = new GenericEntityProperty();
            ((AbstractEntityProperty)property).setValue(val.value);
            property.setPropertyType((PropertyType)propertyTypes.get(val.prty_id));
            property.setScriptable(val.script_id != null);
            property.setDynamic(ScriptType.DYNAMIC_PROPERTY.name().equals(val.script_type));
            property.setOrdinal(val.ordinal);
            entity.getProperties().add(property);
        }
        Long2ObjectMap<String> vocabularyURLMap = null;
        Long2ObjectOpenHashMap terms = new Long2ObjectOpenHashMap();
        for (VocabularyTermRecord val : this.propertySetQuery.getEntityPropertyVocabularyTermValues(entityIDs)) {
            if (vocabularyURLMap == null) {
                vocabularyURLMap = this.getVocabularyURLs();
            }
            IEntityPropertiesHolder entity = entities.get(val.entity_id);
            VocabularyTermEntityProperty property = new VocabularyTermEntityProperty();
            VocabularyTerm vocabularyTerm = (VocabularyTerm)terms.get(val.id);
            if (vocabularyTerm == null) {
                vocabularyTerm = new VocabularyTerm();
                vocabularyTerm.setCode(val.code);
                vocabularyTerm.setLabel(val.label);
                vocabularyTerm.setDescription(val.description);
                String template = (String)vocabularyURLMap.get(val.covo_id);
                if (template != null) {
                    String url = template.replaceAll(BasicConstant.DEPRECATED_VOCABULARY_URL_TEMPLATE_TERM_PATTERN, val.code);
                    url = url.replaceAll(BasicConstant.VOCABULARY_URL_TEMPLATE_TERM_PATTERN, val.code);
                    vocabularyTerm.setUrl(url);
                }
                terms.put(val.id, (Object)vocabularyTerm);
            }
            property.setVocabularyTerm(vocabularyTerm);
            property.setPropertyType((PropertyType)propertyTypes.get(val.prty_id));
            property.setOrdinal(val.ordinal);
            entity.getProperties().add(property);
        }
        Long2ObjectMap<MaterialType> materialTypes = null;
        Long2ObjectOpenHashMap materials = new Long2ObjectOpenHashMap();
        for (MaterialEntityPropertyRecord val : this.propertySetQuery.getEntityPropertyMaterialValues(entityIDs)) {
            if (materialTypes == null) {
                materialTypes = this.getMaterialTypes();
            }
            IEntityPropertiesHolder entity = entities.get(val.entity_id);
            MaterialEntityProperty property = new MaterialEntityProperty();
            Material material = (Material)materials.get(val.id);
            if (material == null) {
                material = new Material();
                material.setCode(val.code);
                material.setMaterialType((MaterialType)materialTypes.get(val.maty_id));
                material.setId(val.id);
                materials.put(val.id, (Object)material);
            }
            property.setMaterial(material);
            property.setPropertyType((PropertyType)propertyTypes.get(val.prty_id));
            property.setOrdinal(val.ordinal);
            entity.getProperties().add(property);
        }
    }

    private Long2ObjectMap<PropertyType> getPropertyTypes() {
        PropertyType[] types = this.query.getPropertyTypes();
        Long2ObjectOpenHashMap propertyTypeMap = new Long2ObjectOpenHashMap(types.length);
        PropertyType[] propertyTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyType t = propertyTypeArray[n2];
            propertyTypeMap.put(t.getId(), (Object)t);
            ++n2;
        }
        propertyTypeMap.trim();
        return propertyTypeMap;
    }

    private Long2ObjectMap<String> getVocabularyURLs() {
        CodeRecord[] vocabURLs = this.query.getVocabularyURLTemplates();
        Long2ObjectOpenHashMap vocabularyURLMap = new Long2ObjectOpenHashMap(vocabURLs.length);
        CodeRecord[] codeRecordArray = vocabURLs;
        int n = vocabURLs.length;
        int n2 = 0;
        while (n2 < n) {
            CodeRecord vocabURL = codeRecordArray[n2];
            vocabularyURLMap.put(vocabURL.id, (Object)vocabURL.code);
            ++n2;
        }
        vocabularyURLMap.trim();
        return vocabularyURLMap;
    }

    private Long2ObjectMap<MaterialType> getMaterialTypes() {
        CodeRecord[] typeCodes = this.query.getMaterialTypes();
        Long2ObjectOpenHashMap materialTypeMap = new Long2ObjectOpenHashMap(typeCodes.length);
        CodeRecord[] codeRecordArray = typeCodes;
        int n = typeCodes.length;
        int n2 = 0;
        while (n2 < n) {
            CodeRecord t = codeRecordArray[n2];
            MaterialType type = new MaterialType();
            type.setCode(t.code);
            materialTypeMap.put(t.id, (Object)type);
            ++n2;
        }
        materialTypeMap.trim();
        return materialTypeMap;
    }
}

