/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.db.mapper.LongSetMapper;
import ch.systemsx.cisd.common.db.mapper.StringArrayMapper;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.CodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IPropertyListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.MaterialEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.VocabularyTermRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DataSetTypeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DataStoreRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetCodeWithShareIdRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetLocationNodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetRelationRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.ExternalDataManagementSystemRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaProjectWithEntityId;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Date;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.TypeMapper;

@Private
@Friend(toClasses={DataStoreRecord.class})
public interface IDatasetListingQuery
extends BaseQuery,
IPropertyListingQuery {
    public static final int FETCH_SIZE = 1000;
    public static final String SELECT_ALL = "select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id ";
    public static final String SELECT_ALL_EXTERNAL_DATAS = "select * from data join external_data on data.id = external_data.data_id ";

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  WHERE data.expe_id = ?{1}")
    public DataIterator<DatasetRecord> getDatasetsForExperiment(long var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  JOIN metaproject_assignments ma ON data.id=ma.data_id WHERE ma.mepr_id = ?{1}")
    public DataIterator<DatasetRecord> getDatasetsForMetaproject(long var1);

    @Select(sql="with recursive connected_data as ( select * from data as d left outer join external_data as ed on d.id = ed.data_id left outer join link_data as ld on d.id = ld.data_id where expe_id = ?{1}    or samp_id in (with recursive connected_samples as                     (select id from samples where expe_id = ?{1}                      union select s.id from connected_samples as cs                                        inner join sample_relationships as sr on sr.sample_id_parent = cs.id                                        left join samples as s on s.id = sr.sample_id_child)                   select * from connected_samples) union select d.*, ed.*, ld.* from connected_data as cd                        inner join data_set_relationships as dr on dr.data_id_parent = cd.id                        left join data as d on d.id = dr.data_id_child                        left outer join external_data as ed on d.id = ed.data_id                       left outer join link_data as ld on d.id = ld.data_id) select * from connected_data")
    public DataIterator<DatasetRecord> getDataSetsForExperimentAndDescendents(long var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  WHERE data.samp_id=?{1}", fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasetsForSample(long var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  WHERE data.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasetsForSamples(LongSet var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  WHERE data.id > ?{1}", fetchSize=1000)
    public DataIterator<DatasetRecord> getNewDataSets(long var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  WHERE data.id > ?{2} AND data.samp_id IN (SELECT id FROM samples s WHERE s.saty_id=?{1})", fetchSize=1000)
    public DataIterator<DatasetRecord> getNewDataSetsForSampleType(long var1, long var3);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id     WHERE data.dast_id = ?{1} AND external_data.status = 'AVAILABLE'     AND data.registration_timestamp < ?{2} AND external_data.present_in_archive=?{3}", fetchSize=1000)
    public DataIterator<DatasetRecord> getAvailableExtDatasRegisteredBefore(long var1, Date var3, boolean var4);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id     WHERE data.dast_id = ?{1} AND external_data.status = 'AVAILABLE'     AND data.registration_timestamp < ?{2} AND external_data.present_in_archive=?{3}     AND data.dsty_id = ?{4}", fetchSize=1000)
    public DataIterator<DatasetRecord> getAvailableExtDatasRegisteredBeforeWithDataSetType(long var1, Date var3, boolean var4, long var5);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id     WHERE data.dast_id = ?{1} AND external_data.status = 'AVAILABLE'     AND data.access_timestamp < ?{2} AND external_data.present_in_archive=?{3}", fetchSize=1000)
    public DataIterator<DatasetRecord> getAvailableExtDatasAccessedBefore(long var1, Date var3, boolean var4);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id     WHERE data.dast_id = ?{1} AND external_data.status = 'AVAILABLE'     AND data.access_timestamp < ?{2} AND external_data.present_in_archive=?{3}     AND data.dsty_id = ?{4}", fetchSize=1000)
    public DataIterator<DatasetRecord> getAvailableExtDatasAccessedBeforeWithDataSetType(long var1, Date var3, boolean var4, long var5);

    @Select(sql="select id from data where data.samp_id=?{1}", fetchSize=1000)
    public DataIterator<Long> getDatasetIdsForSample(long var1);

    @Select(sql="select id from data where data.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<Long> getDatasetIdsForSamples(LongSet var1);

    @Select(sql="select * from data_set_relationships where data_id_child = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRelationRecord> listParentDataSetIds(LongSet var1);

    @Select(sql="select * from data_set_relationships where data_id_parent = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRelationRecord> listChildrenDataSetIds(LongSet var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id     WHERE data.id IN (SELECT data_id_child FROM data_set_relationships r WHERE r.data_id_parent = any(?{1}))", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRecord> getChildDatasetsForParents(LongSet var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  WHERE data.id IN (SELECT data_id_parent FROM data_set_relationships r WHERE r.data_id_child=?{1})", fetchSize=1000)
    public DataIterator<DatasetRecord> getParentDatasetsForChild(long var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  WHERE data.ctnr_id=?{1}", fetchSize=1000)
    public DataIterator<DatasetRecord> getContainedDatasetsForContainer(long var1);

    @Select(value="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  where data.id=?{1}")
    public DatasetRecord getDataset(long var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  where (select dbin_id from data_set_types t where t.id = data.dsty_id) = ?{1}", fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasets(long var1);

    @Select(sql="select id, code, data_set_kind from data_set_types where dbin_id=?{1}")
    public DataSetTypeRecord[] getDatasetTypes(long var1);

    @Select(sql="select id, code, download_url from data_stores where dbin_id=?{1}")
    public DataStoreRecord[] getDataStores(long var1);

    @Select(sql="select id, code from file_format_types where dbin_id=?{1}")
    public CodeRecord[] getFileFormatTypes(long var1);

    @Select(sql="select id, code from locator_types")
    public CodeRecord[] getLocatorTypes();

    @Select(sql="select id, code, label, url_template, is_openbis from external_data_management_systems where dbin_id=?{1}")
    public ExternalDataManagementSystemRecord[] getExternalDataManagementSystems(long var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  where data.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasets(LongSet var1);

    @Select(sql="select data.*, external_data.*, link_data.* from data left outer join external_data on data.id = external_data.data_id left outer join link_data on data.id = link_data.data_id  where data.code = any(?{1})", parameterBindings={StringArrayMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasets(String[] var1);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id  where data.dast_id = ?{1} and is_placeholder = false", fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasetsByDataStoreId(long var1);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id  where data.dast_id = ?{1} and is_placeholder = false order by registration_timestamp limit ?{2}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreId(long var1, int var3);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id  where data.dast_id = ?{1} and is_placeholder = false and registration_timestamp > ?{2} order by registration_timestamp limit ?{3}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreId(long var1, Date var3, int var4);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id  where data.dast_id = ?{1} and is_placeholder = false and registration_timestamp = ?{2} order by registration_timestamp", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreId(long var1, Date var3);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id  where data.dast_id = ?{1} and is_placeholder = false and size is null order by data.code limit ?{2}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreIdWithUnknownSize(long var1, int var3);

    @Select(sql="select * from data join external_data on data.id = external_data.data_id  where data.dast_id = ?{1} and is_placeholder = false and size is null and data.code > ?{3} order by data.code limit ?{2}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreIdWithUnknownSize(long var1, int var3, String var4);

    @Select(sql="SELECT code, share_id FROM data_all LEFT OUTER JOIN external_data ON data_all.id = external_data.data_id WHERE data_all.dast_id = ?{1}", fetchSize=1000)
    public DataIterator<DatasetCodeWithShareIdRecord> getAllDatasetsWithShareIdsByDataStoreId(long var1);

    @Select(sql="select data_id_child from data_set_relationships where data_id_parent = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<Long> getDatasetChildrenIds(LongSet var1);

    @Select(sql="select id from data where ctnr_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<Long> getContainedDataSetIds(LongSet var1);

    @Select(sql="select code from data where ctnr_id = (select id from data where code = ?{1})", fetchSize=1000)
    public DataIterator<String> getContainedDataSetCodes(String var1);

    @Select(sql="SELECT pr.ds_id as entity_id, etpt.prty_id, etpt.script_id, pr.value, sc.script_type       FROM data_set_properties pr      JOIN data_set_type_property_types etpt ON pr.dstpt_id=etpt.id      LEFT OUTER JOIN scripts sc ON etpt.script_id = sc.id     WHERE pr.value is not null AND pr.ds_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet var1);

    @Select(sql="SELECT pr.ds_id as entity_id, etpt.prty_id, etpt.script_id, pr.value       FROM data_set_properties pr      JOIN data_set_type_property_types etpt ON pr.dstpt_id=etpt.id      JOIN property_types pt ON etpt.prty_id=pt.id     WHERE pr.value is not null AND pr.ds_id = any(?{1}) AND pt.code = ?{2}", parameterBindings={LongSetMapper.class, TypeMapper.class}, fetchSize=1000)
    public DataIterator<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet var1, String var2);

    @Select(sql="SELECT pr.ds_id as entity_id, etpt.prty_id, etpt.script_id, cvte.id, cvte.covo_id, cvte.code, cvte.label, cvte.ordinal, cvte.is_official, cvte.description      FROM data_set_properties pr      JOIN data_set_type_property_types etpt ON pr.dstpt_id=etpt.id      JOIN controlled_vocabulary_terms cvte ON pr.cvte_id=cvte.id     WHERE pr.cvte_id is not null AND pr.ds_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<VocabularyTermRecord> getEntityPropertyVocabularyTermValues(LongSet var1);

    @Select(sql="SELECT pr.ds_id as entity_id, etpt.prty_id, etpt.script_id, m.id, m.code, m.maty_id      FROM data_set_properties pr      JOIN data_set_type_property_types etpt ON pr.dstpt_id=etpt.id      JOIN materials m ON pr.mate_prop_id=m.id      WHERE pr.mate_prop_id is not null AND pr.ds_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<MaterialEntityPropertyRecord> getEntityPropertyMaterialValues(LongSet var1);

    @Select(sql="WITH RECURSIVE connected_data(id, code, ctnr_id, ctnr_order, dast_id, location) AS (    SELECT d.id, d.code, d.ctnr_id, d.ctnr_order, d.dast_id, ed.location FROM data AS d LEFT OUTER JOIN external_data AS ed ON d.id = ed.data_id WHERE d.code = ?{1}  UNION ALL    SELECT d.id, d.code, d.ctnr_id, d.ctnr_order, d.dast_id, ed.location    FROM connected_data AS cd INNER JOIN data AS d ON cd.id = d.ctnr_id LEFT OUTER JOIN external_data AS ed ON d.id = ed.data_id)SELECT c.id, c.code, c.ctnr_id, c.ctnr_order, c.location, d.code as data_store_code, d.remote_url as data_store_url FROM connected_data c JOIN data_stores d ON c.dast_id = d.id")
    public DataIterator<DatasetLocationNodeRecord> listLocationsByDatasetCode(String var1);

    @Select(sql="select m.id as id, m.name as name, m.description as description, p.user_id as owner_name,  m.private as is_private, m.creation_date as creation_date, ma.data_id as entity_id  from metaprojects m, metaproject_assignments ma, persons p  where ma.data_id = any(?{1}) and m.owner = ?{2} and m.id = ma.mepr_id and m.owner = p.id", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<MetaProjectWithEntityId> getMetaprojects(LongSet var1, Long var2);
}

