/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.experimentlister;

import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.experimentlister.ExperimentRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.experimentlister.IExperimentLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.experimentlister.IExperimentListingQuery;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.QueryTool;
import org.apache.commons.lang.StringUtils;

public class ExperimentLister
implements IExperimentLister {
    private IDAOFactory daoFactory;
    private String baseIndexURL;
    private IExperimentListingQuery query;

    public ExperimentLister(IDAOFactory daoFactory, String baseIndexURL) {
        this(daoFactory, baseIndexURL, (IExperimentListingQuery)QueryTool.getManagedQuery(IExperimentListingQuery.class));
    }

    public ExperimentLister(IDAOFactory daoFactory, String baseIndexURL, IExperimentListingQuery query) {
        if (daoFactory == null) {
            throw new IllegalArgumentException("DaoFactory was null");
        }
        if (baseIndexURL == null) {
            throw new IllegalArgumentException("BaseIndexURL was null");
        }
        if (query == null) {
            throw new IllegalArgumentException("Query was null");
        }
        this.daoFactory = daoFactory;
        this.baseIndexURL = baseIndexURL;
        this.query = query;
    }

    @Override
    public List<Experiment> listExperiments(List<ExperimentIdentifier> experimentIdentifiers, ExperimentFetchOptions experimentFetchOptions) {
        if (experimentIdentifiers == null) {
            throw new IllegalArgumentException("ExperimentIdentifiers were null");
        }
        if (experimentFetchOptions == null) {
            throw new IllegalArgumentException("ExperimentFetchOptions were null");
        }
        if (!experimentFetchOptions.isSubsetOf(new ExperimentFetchOption[]{ExperimentFetchOption.BASIC})) {
            throw new IllegalArgumentException("Currently only " + ExperimentFetchOption.BASIC + " fetch option is supported by this method");
        }
        ExperimentIdentifiers identifiers = new ExperimentIdentifiers(experimentIdentifiers);
        DataIterator<ExperimentRecord> iterator = this.query.listExperiments(identifiers.getDatabaseInstanceCodes(), identifiers.getSpaceCodes(), identifiers.getProjectCodes(), identifiers.getExperimentCodes());
        return this.handleResults(iterator, identifiers);
    }

    @Override
    public List<Experiment> listExperimentsForProjects(List<ProjectIdentifier> projectIdentifiers, ExperimentFetchOptions experimentFetchOptions) {
        if (projectIdentifiers == null) {
            throw new IllegalArgumentException("ProjectIdentifiers were null");
        }
        if (experimentFetchOptions == null) {
            throw new IllegalArgumentException("ExperimentFetchOptions were null");
        }
        if (!experimentFetchOptions.isSubsetOf(new ExperimentFetchOption[]{ExperimentFetchOption.BASIC})) {
            throw new IllegalArgumentException("Currently only " + ExperimentFetchOption.BASIC + " fetch option is supported by this method");
        }
        ProjectIdentifiers identifiers = new ProjectIdentifiers(projectIdentifiers);
        DataIterator<ExperimentRecord> iterator = this.query.listExperimentsForProjects(identifiers.getDatabaseInstanceCodes(), identifiers.getSpaceCodes(), identifiers.getProjectCodes());
        return this.handleResults(iterator, identifiers);
    }

    private List<Experiment> handleResults(DataIterator<ExperimentRecord> iterator, ProjectIdentifiers identifiers) {
        if (iterator != null) {
            LinkedList<ExperimentRecord> results = new LinkedList<ExperimentRecord>();
            while (iterator.hasNext()) {
                results.add((ExperimentRecord)iterator.next());
            }
            if (identifiers.size() > 1) {
                identifiers.filter(results);
            }
            return this.createExperiments(results);
        }
        return Collections.emptyList();
    }

    private List<Experiment> createExperiments(List<ExperimentRecord> records) {
        ArrayList<Experiment> result = new ArrayList<Experiment>(records.size());
        for (ExperimentRecord record : records) {
            result.add(this.createExperiment(record));
        }
        return result;
    }

    private Experiment createExperiment(ExperimentRecord record) {
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(this.createDatabaseInstanceIdentifier(record).getDatabaseInstanceCode(), record.s_code, record.pr_code, record.e_code);
        Experiment experiment = new Experiment();
        experiment.setFetchOptions(new ExperimentFetchOptions());
        experiment.setId(record.e_id);
        experiment.setModificationDate(record.e_modification_timestamp);
        experiment.setCode(record.e_code);
        experiment.setPermId(record.e_perm_id);
        experiment.setPermlink(PermlinkUtilities.createPermlinkURL(this.baseIndexURL, EntityKind.EXPERIMENT, record.e_perm_id));
        experiment.setExperimentType(this.createExperimentType(record));
        experiment.setIdentifier(experimentIdentifier.toString());
        experiment.setProject(this.createProject(record));
        experiment.setRegistrator(this.createPerson(record));
        experiment.setModifier(this.createModifier(record));
        experiment.setRegistrationDate(record.e_registration_timestamp);
        experiment.setModificationDate(record.e_modification_timestamp);
        return experiment;
    }

    private ExperimentType createExperimentType(ExperimentRecord record) {
        ExperimentType experimentType = new ExperimentType();
        experimentType.setCode(record.et_code);
        experimentType.setDescription(record.et_description);
        experimentType.setDatabaseInstance(this.createDatabaseInstance(record));
        return experimentType;
    }

    private DatabaseInstanceIdentifier createDatabaseInstanceIdentifier(ExperimentRecord record) {
        return new DatabaseInstanceIdentifier(record.d_is_original_source, record.d_code);
    }

    private DatabaseInstance createDatabaseInstance(ExperimentRecord record) {
        DatabaseInstance instance = new DatabaseInstance();
        instance.setId(record.d_id);
        instance.setCode(record.d_code);
        instance.setUuid(record.d_uuid);
        instance.setHomeDatabase(record.d_is_original_source);
        instance.setIdentifier(this.createDatabaseInstanceIdentifier(record).toString());
        return instance;
    }

    private Space createSpace(ExperimentRecord record) {
        SpaceIdentifier spaceIdentifier = new SpaceIdentifier(this.createDatabaseInstanceIdentifier(record).getDatabaseInstanceCode(), record.s_code);
        Space space = new Space();
        space.setId(record.s_id);
        space.setCode(record.s_code);
        space.setDescription(record.s_description);
        space.setInstance(this.createDatabaseInstance(record));
        space.setRegistrationDate(record.s_registration_timestamp);
        space.setIdentifier(spaceIdentifier.toString());
        return space;
    }

    private Person createPerson(ExperimentRecord record) {
        Person person = new Person();
        person.setFirstName(record.pe_first_name);
        person.setLastName(record.pe_last_name);
        person.setEmail(record.pe_email);
        person.setUserId(record.pe_user_id);
        person.setDatabaseInstance(this.createDatabaseInstance(record));
        person.setRegistrationDate(record.pe_registration_timestamp);
        return person;
    }

    private Person createModifier(ExperimentRecord record) {
        Person person = new Person();
        person.setFirstName(record.mod_first_name);
        person.setLastName(record.mod_last_name);
        person.setEmail(record.mod_email);
        person.setUserId(record.mod_user_id);
        person.setDatabaseInstance(this.createDatabaseInstance(record));
        person.setRegistrationDate(record.mod_registration_timestamp);
        return person;
    }

    private Project createProject(ExperimentRecord record) {
        ProjectIdentifier projectIdentifier = new ProjectIdentifier(this.createDatabaseInstanceIdentifier(record).getDatabaseInstanceCode(), record.s_code, record.pr_code);
        Project project = new Project();
        project.setId(record.pr_id);
        project.setPermId(record.pr_perm_id);
        project.setModificationDate(record.pr_modification_timestamp);
        project.setRegistrationDate(record.pr_registration_timestamp);
        project.setCode(record.pr_code);
        project.setDescription(record.pr_description);
        project.setSpace(this.createSpace(record));
        project.setRegistrationDate(record.pr_registration_timestamp);
        project.setIdentifier(projectIdentifier.toString());
        return project;
    }

    private class ExperimentIdentifiers
    extends ProjectIdentifiers {
        private Set<String> experimentCodes;

        public ExperimentIdentifiers(List<ExperimentIdentifier> identifiers) {
            super(identifiers);
            this.experimentCodes = new HashSet<String>(identifiers.size());
            for (ExperimentIdentifier identifier : identifiers) {
                this.experimentCodes.add(identifier.getExperimentCode());
            }
        }

        public String[] getExperimentCodes() {
            return this.experimentCodes.toArray(new String[this.experimentCodes.size()]);
        }

        @Override
        public void filter(List<ExperimentRecord> records) {
            Iterator<ExperimentRecord> iterator = records.iterator();
            while (iterator.hasNext()) {
                ExperimentRecord record = iterator.next();
                ExperimentIdentifier identifier = new ExperimentIdentifier(record.d_code, record.s_code, record.pr_code, record.e_code);
                if (this.contains(identifier)) continue;
                iterator.remove();
            }
        }
    }

    private class ProjectIdentifiers {
        private Set<ProjectIdentifier> identifiersSet;
        private Set<String> databaseInstanceCodes;
        private Set<String> spaceCodes;
        private Set<String> projectCodes;

        public ProjectIdentifiers(List<? extends ProjectIdentifier> identifiers) {
            this.identifiersSet = new HashSet<ProjectIdentifier>(identifiers.size());
            this.databaseInstanceCodes = new HashSet<String>(identifiers.size());
            this.spaceCodes = new HashSet<String>(identifiers.size());
            this.projectCodes = new HashSet<String>(identifiers.size());
            for (ProjectIdentifier projectIdentifier : identifiers) {
                if (StringUtils.isBlank((String)projectIdentifier.getDatabaseInstanceCode())) {
                    projectIdentifier.setDatabaseInstanceCode(ExperimentLister.this.daoFactory.getHomeDatabaseInstance().getCode());
                }
                this.identifiersSet.add(projectIdentifier);
                this.databaseInstanceCodes.add(projectIdentifier.getDatabaseInstanceCode());
                this.spaceCodes.add(projectIdentifier.getSpaceCode());
                this.projectCodes.add(projectIdentifier.getProjectCode());
            }
        }

        public String[] getDatabaseInstanceCodes() {
            return this.databaseInstanceCodes.toArray(new String[this.databaseInstanceCodes.size()]);
        }

        public String[] getSpaceCodes() {
            return this.spaceCodes.toArray(new String[this.spaceCodes.size()]);
        }

        public String[] getProjectCodes() {
            return this.projectCodes.toArray(new String[this.projectCodes.size()]);
        }

        public boolean contains(ProjectIdentifier identifier) {
            return this.identifiersSet.contains(identifier);
        }

        public int size() {
            return this.identifiersSet.size();
        }

        public void filter(List<ExperimentRecord> records) {
            Iterator<ExperimentRecord> iterator = records.iterator();
            while (iterator.hasNext()) {
                ExperimentRecord record = iterator.next();
                ProjectIdentifier identifier = new ProjectIdentifier(record.d_code, record.s_code, record.pr_code);
                if (this.contains(identifier)) continue;
                iterator.remove();
            }
        }
    }
}

