/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.CodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.EntityPropertiesEnricher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesEnricher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesHolderResolver;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.AbstractLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.SecondaryEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaProjectWithEntityId;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.MaterialListerDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.MaterialRecord;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectCriteria;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.lemnik.eodsql.DataIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

@Friend(toClasses={MaterialRecord.class, IMaterialListingQuery.class})
public class MaterialLister
extends AbstractLister
implements IMaterialLister {
    private final long databaseInstanceId;
    private final DatabaseInstance databaseInstance;
    private final IMaterialListingQuery query;
    private final IEntityPropertiesEnricher propertiesEnricher;
    private final Long userId;

    public static IMaterialLister create(IDAOFactory daoFactory, String baseIndexURL, Long userId) {
        MaterialListerDAO dao = MaterialListerDAO.create(daoFactory);
        SecondaryEntityDAO referencedEntityDAO = SecondaryEntityDAO.create(daoFactory);
        return MaterialLister.create(dao, referencedEntityDAO, baseIndexURL, userId);
    }

    static IMaterialLister create(MaterialListerDAO dao, SecondaryEntityDAO referencedEntityDAO, String baseIndexURL, Long userId) {
        IMaterialListingQuery query = dao.getQuery();
        EntityPropertiesEnricher propertiesEnricher = new EntityPropertiesEnricher(query, dao.getPropertySetQuery());
        return new MaterialLister(dao.getDatabaseInstanceId(), dao.getDatabaseInstance(), query, propertiesEnricher, referencedEntityDAO, userId);
    }

    MaterialLister(long databaseInstanceId, DatabaseInstance databaseInstance, IMaterialListingQuery query, IEntityPropertiesEnricher propertiesEnricher, SecondaryEntityDAO referencedEntityDAO, Long userId) {
        super(referencedEntityDAO);
        assert (query != null);
        this.databaseInstanceId = databaseInstanceId;
        this.databaseInstance = databaseInstance;
        this.query = query;
        this.propertiesEnricher = propertiesEnricher;
        this.userId = userId;
    }

    @Override
    public List<Material> list(ListMaterialCriteria criteria, boolean withProperties) {
        Long2ObjectMap<Material> materialMap = this.getMaterialsByCriteria(criteria);
        return this.convertAndEnrich(materialMap, withProperties);
    }

    @Override
    public List<Material> list(MetaprojectCriteria criteria, boolean withProperties) {
        Long2ObjectMap<Material> materialMap = this.getMaterialsByCriteria(criteria);
        return this.convertAndEnrich(materialMap, withProperties);
    }

    @Override
    public Collection<TechId> listMaterialsByMaterialProperties(Collection<TechId> materialIds) {
        DataIterator<Long> result = this.query.getMaterialIdsByMaterialProperties((LongSet)new LongOpenHashSet(TechId.asLongs(materialIds)));
        return new HashSet<TechId>(TechId.createList(MaterialLister.asList(result)));
    }

    private void filterCodesAndTypes(Long2ObjectMap<Material> materialMap, Collection<MaterialIdentifier> identifiers) {
        HashSet<String> identifiersMap = new HashSet<String>();
        for (MaterialIdentifier ident : identifiers) {
            identifiersMap.add(ident.toString());
        }
        LinkedList<Long> missingIds = new LinkedList<Long>();
        for (Long key : materialMap.keySet()) {
            Material entry = (Material)materialMap.get((Object)key);
            if (identifiersMap.contains(String.format("%s (%s)", entry.getCode(), entry.getMaterialType().getCode()))) continue;
            missingIds.add(key);
        }
        for (Long key : missingIds) {
            materialMap.remove((Object)key);
        }
    }

    private Long2ObjectMap<Material> getMaterialsByCriteria(ListMaterialCriteria criteria) {
        Collection<Long> materialIdsOrNull = criteria.tryGetMaterialIds();
        MaterialType materialTypeOrNull = criteria.tryGetMaterialType();
        Collection<MaterialIdentifier> identifiers = criteria.tryGetMaterialIdentifiers();
        if (materialTypeOrNull != null) {
            return this.asMaterials((Iterable<MaterialRecord>)this.getIteratorByType(materialTypeOrNull), materialTypeOrNull);
        }
        if (materialIdsOrNull != null) {
            return this.asMaterials((Iterable<MaterialRecord>)this.getIteratorByIds(materialIdsOrNull), null);
        }
        if (identifiers != null) {
            return this.getMaterialsByIndentifiers(identifiers);
        }
        throw new IllegalArgumentException("At least one of the three criterias should be not null.");
    }

    private Long2ObjectMap<Material> getMaterialsByCriteria(MetaprojectCriteria criteria) {
        return this.asMaterials((Iterable<MaterialRecord>)this.getIteratorByMetaprojectId(criteria.getMetaprojectId()), null);
    }

    private Long2ObjectMap<Material> getMaterialsByIndentifiers(Collection<MaterialIdentifier> identifiers) {
        String[] materialCodes = CollectionUtils.collect(identifiers, (Transformer)new Transformer<MaterialIdentifier, String>(){

            public String transform(MaterialIdentifier arg0) {
                return arg0.getCode();
            }
        }).toArray(new String[0]);
        Long2ObjectMap<Material> materialMap = this.asMaterials((Iterable<MaterialRecord>)this.getIteratorByCodes(materialCodes), null);
        this.filterCodesAndTypes(materialMap, identifiers);
        return materialMap;
    }

    private List<Material> convertAndEnrich(Long2ObjectMap<Material> materialMap, boolean withProperties) {
        if (withProperties) {
            this.enrichWithProperties(materialMap);
        }
        if (this.userId != null) {
            this.enrichWithMetaProjects(materialMap);
        }
        return MaterialLister.asList(materialMap);
    }

    private DataIterator<MaterialRecord> getIteratorByType(MaterialType materialType) {
        assert (materialType != null);
        return this.query.getMaterialsForMaterialType(this.databaseInstanceId, materialType.getId());
    }

    private DataIterator<MaterialRecord> getIteratorByIds(Collection<Long> materialIds) {
        return this.query.getMaterialsForMaterialTypeWithIds(this.databaseInstanceId, (LongSet)new LongOpenHashSet(materialIds));
    }

    private DataIterator<MaterialRecord> getIteratorByCodes(String[] materialCodes) {
        return this.query.getMaterialsForMaterialCodes(this.databaseInstanceId, materialCodes);
    }

    private DataIterator<MaterialRecord> getIteratorByMetaprojectId(Long metaprojectId) {
        return this.query.getMaterialsForMetaprojectId(this.databaseInstanceId, metaprojectId);
    }

    private Long2ObjectMap<Material> asMaterials(Iterable<MaterialRecord> materials, MaterialType materialTypeOrNull) {
        List<MaterialRecord> materialRecords = MaterialLister.asList(materials);
        Long2ObjectMap<Material> materialMap = this.createMaterials(materialRecords, materialTypeOrNull);
        return materialMap;
    }

    private Long2ObjectMap<Material> createMaterials(Iterable<MaterialRecord> records, MaterialType materialTypeOrNull) {
        Long2ObjectOpenHashMap materials = new Long2ObjectOpenHashMap();
        Long2ObjectMap<MaterialType> materialTypesOrNull = null;
        if (materialTypeOrNull == null) {
            materialTypesOrNull = this.getMaterialTypes();
        }
        for (MaterialRecord record : records) {
            materials.put(record.id, (Object)this.createMaterial(record, materialTypeOrNull, materialTypesOrNull));
        }
        return materials;
    }

    private Material createMaterial(MaterialRecord record, MaterialType materialTypeOrNull, Long2ObjectMap<MaterialType> materialTypesOrNull) {
        Material material = new Material();
        material.setId(record.id);
        material.setCode(record.code);
        MaterialType materialType = materialTypeOrNull != null ? materialTypeOrNull : (MaterialType)materialTypesOrNull.get(record.maty_id);
        material.setMaterialType(materialType);
        assert (record.dbin_id == this.databaseInstanceId);
        material.setDatabaseInstance(this.databaseInstance);
        material.setRegistrator(this.getOrCreateActor(record.pers_id_registerer));
        material.setRegistrationDate(record.registration_timestamp);
        material.setModificationDate(record.modification_timestamp);
        material.setProperties(new ArrayList<IEntityProperty>());
        return material;
    }

    private static <T> List<T> asList(Iterable<T> items) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : items) {
            result.add(item);
        }
        return result;
    }

    private static <T> List<T> asList(Long2ObjectMap<T> items) {
        ArrayList result = new ArrayList();
        result.addAll(items.values());
        return result;
    }

    private void enrichWithMetaProjects(Long2ObjectMap<Material> resultMap) {
        for (MetaProjectWithEntityId metaProject : this.query.getMetaprojects(resultMap.keySet(), this.userId)) {
            Metaproject mp = new Metaproject();
            mp.setId(metaProject.id);
            mp.setCreationDate(metaProject.creation_date);
            mp.setDescription(metaProject.description);
            mp.setIdentifier("/" + metaProject.owner_name + "/" + metaProject.name);
            mp.setName(metaProject.name);
            mp.setOwnerId(metaProject.owner_name);
            mp.setPrivate(metaProject.is_private);
            Material material = (Material)resultMap.get((Object)metaProject.entity_id);
            if (material == null) continue;
            Collection<Metaproject> mps = material.getMetaprojects();
            if (mps == null) {
                mps = new HashSet<Metaproject>();
                material.setMetaprojects(mps);
            }
            mps.add(mp);
        }
    }

    private void enrichWithProperties(final Long2ObjectMap<Material> resultMap) {
        this.propertiesEnricher.enrich(resultMap.keySet(), new IEntityPropertiesHolderResolver(){

            @Override
            public Material get(long id) {
                return (Material)resultMap.get(id);
            }
        });
    }

    private static Long2ObjectMap<Material> asMap(Iterable<Material> materials) {
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        for (Material material : materials) {
            map.put((Object)material.getId(), (Object)material);
        }
        return map;
    }

    @Override
    public void enrichWithProperties(List<Material> materials) {
        this.setEmptyProperties(materials);
        Long2ObjectMap<Material> materialMap = MaterialLister.asMap(materials);
        this.enrichWithProperties(materialMap);
        this.enrichRepeatedMaterialsWithProperties(materials, materialMap);
    }

    private void enrichRepeatedMaterialsWithProperties(List<Material> allMaterials, Long2ObjectMap<Material> enrichedMaterials) {
        for (Material material : allMaterials) {
            if (!material.getProperties().isEmpty()) continue;
            Material enrichedMaterial = (Material)enrichedMaterials.get((Object)material.getId());
            material.setProperties(new ArrayList<IEntityProperty>(enrichedMaterial.getProperties()));
        }
    }

    private void setEmptyProperties(List<Material> materials) {
        for (Material material : materials) {
            material.setProperties(new ArrayList<IEntityProperty>());
        }
    }

    private Long2ObjectMap<MaterialType> getMaterialTypes() {
        CodeRecord[] typeCodes = this.query.getMaterialTypes();
        Long2ObjectOpenHashMap materialTypeMap = new Long2ObjectOpenHashMap(typeCodes.length);
        CodeRecord[] codeRecordArray = typeCodes;
        int n = typeCodes.length;
        int n2 = 0;
        while (n2 < n) {
            CodeRecord t = codeRecordArray[n2];
            MaterialType type = new MaterialType();
            type.setCode(t.code);
            materialTypeMap.put(t.id, (Object)type);
            ++n2;
        }
        materialTypeMap.trim();
        return materialTypeMap;
    }
}

